/*
 * Decompiled with CFR 0.152.
 */
package com.expedient.adventofcodejade.util;

public class NumTools {
    private static final int[] POWERS_OF_TEN_INT = new int[]{10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
    private static final long[] POWERS_OF_TEN_LONG = new long[]{10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};

    public static int fastCatInt(int one, int two) {
        int power = 0;
        while (two >= POWERS_OF_TEN_INT[power]) {
            ++power;
        }
        return POWERS_OF_TEN_INT[power] * one + two;
    }

    public static long fastCat(long one, long two) {
        int power = 0;
        while (two >= POWERS_OF_TEN_LONG[power]) {
            ++power;
        }
        return POWERS_OF_TEN_LONG[power] * one + two;
    }

    public static long[] solveSystemOfEquations(long[] coefficientsA, long[] coefficientsB, long[] constantsC) {
        long[] a = coefficientsA;
        long[] b = coefficientsB;
        long[] c = constantsC;
        long x = (c[0] * b[1] - c[1] * b[0]) / (a[0] * b[1] - a[1] * b[0]);
        long y = (a[0] * c[1] - a[1] * c[0]) / (a[0] * b[1] - a[1] * b[0]);
        return new long[]{x, y};
    }
}

