/*
 * Decompiled with CFR 0.152.
 */
package com.expedient.adventofcodejade.solutions.year2024.solutionday15helpers;

import com.expedient.adventofcodejade.common.Coordinate;
import com.expedient.adventofcodejade.common.Direction;
import com.expedient.adventofcodejade.solutions.year2024.solutionday15helpers.Actor;

public abstract class MovingActor
extends Actor {
    public MovingActor(Coordinate startPosition, Actor[][] grid) {
        super(startPosition, grid);
    }

    @Override
    public boolean tryMove(Direction direction, boolean dry) {
        Coordinate next;
        switch (direction) {
            default: {
                throw new MatchException(null, null);
            }
            case UP: {
                Coordinate coordinate = new Coordinate(this.position.row() - 1, this.position.col());
                break;
            }
            case DOWN: {
                Coordinate coordinate = new Coordinate(this.position.row() + 1, this.position.col());
                break;
            }
            case LEFT: {
                Coordinate coordinate = new Coordinate(this.position.row(), this.position.col() - 1);
                break;
            }
            case RIGHT: {
                Coordinate coordinate = next = new Coordinate(this.position.row(), this.position.col() + 1);
            }
        }
        if (this.grid[next.row()][next.col()] != null) {
            boolean didMove = this.grid[next.row()][next.col()].tryMove(direction, dry);
            if (didMove && !dry) {
                this.changePosition(next);
            }
            return didMove;
        }
        if (!dry) {
            this.changePosition(next);
        }
        return true;
    }
}

