/*
 * Decompiled with CFR 0.152.
 */
package com.expedient.adventofcodejade.solutions.year2024.solutionday15helpers;

import com.expedient.adventofcodejade.common.Coordinate;
import com.expedient.adventofcodejade.common.Direction;
import com.expedient.adventofcodejade.solutions.year2024.solutionday15helpers.Actor;

public class DoubleBox
extends Actor {
    public DoubleBox(Coordinate startPosition, Actor[][] grid) {
        super(startPosition, grid);
    }

    @Override
    public void changePosition(Coordinate newPosition) {
        this.grid[this.position.row()][this.position.col()] = null;
        this.grid[this.position.row()][this.position.col() + 1] = null;
        this.grid[newPosition.row()][newPosition.col()] = this;
        this.grid[newPosition.row()][newPosition.col() + 1] = this;
        this.position = newPosition;
    }

    @Override
    public boolean tryMove(Direction direction, boolean dry) {
        Actor n;
        Coordinate[] toCheck;
        Coordinate[] coordinateArray;
        switch (direction) {
            default: {
                throw new MatchException(null, null);
            }
            case UP: {
                Coordinate[] coordinateArray2 = new Coordinate[2];
                coordinateArray2[0] = new Coordinate(this.position.row() - 1, this.position.col());
                coordinateArray = coordinateArray2;
                coordinateArray2[1] = new Coordinate(this.position.row() - 1, this.position.col() + 1);
                break;
            }
            case LEFT: {
                Coordinate[] coordinateArray3 = new Coordinate[1];
                coordinateArray = coordinateArray3;
                coordinateArray3[0] = new Coordinate(this.position.row(), this.position.col() - 1);
                break;
            }
            case DOWN: {
                Coordinate[] coordinateArray4 = new Coordinate[2];
                coordinateArray4[0] = new Coordinate(this.position.row() + 1, this.position.col());
                coordinateArray = coordinateArray4;
                coordinateArray4[1] = new Coordinate(this.position.row() + 1, this.position.col() + 1);
                break;
            }
            case RIGHT: {
                Coordinate[] coordinateArray5 = new Coordinate[1];
                coordinateArray = coordinateArray5;
                coordinateArray5[0] = new Coordinate(this.position.row(), this.position.col() + 2);
            }
        }
        for (Coordinate check : toCheck = coordinateArray) {
            n = this.grid[check.row()][check.col()];
            if (n == null || n.position == this.position || n.tryMove(direction, true)) continue;
            return false;
        }
        if (dry) {
            return true;
        }
        for (Coordinate check : toCheck) {
            n = this.grid[check.row()][check.col()];
            if (n == null || n.position == this.position) continue;
            n.tryMove(direction, false);
        }
        switch (direction) {
            case UP: {
                this.changePosition(new Coordinate(this.position.row() - 1, this.position.col()));
                break;
            }
            case DOWN: {
                this.changePosition(new Coordinate(this.position.row() + 1, this.position.col()));
                break;
            }
            case RIGHT: {
                this.changePosition(new Coordinate(this.position.row(), this.position.col() + 1));
                break;
            }
            case LEFT: {
                this.changePosition(new Coordinate(this.position.row(), this.position.col() - 1));
            }
        }
        return true;
    }
}

