/*
 * Decompiled with CFR 0.152.
 */
package com.expedient.adventofcodejade.solutions.year2024;

import com.expedient.adventofcodejade.BaseSolution;
import com.expedient.adventofcodejade.common.Pair;
import com.expedient.adventofcodejade.common.PuzzleInput;
import com.expedient.adventofcodejade.util.StringTools;
import java.util.ArrayList;
import java.util.List;

public class SolutionDay9
extends BaseSolution {
    public SolutionDay9(PuzzleInput input, PuzzleInput sampleInputOne, PuzzleInput sampleInputTwo) {
        super(input, sampleInputOne, sampleInputTwo);
    }

    public static Long calculateCheckSum(FileSystemBlock[] fileSystem) {
        long checkSum = 0L;
        for (int i = 0; i < fileSystem.length; ++i) {
            if (fileSystem[i] == null) continue;
            checkSum += (long)i * (long)fileSystem[i].fileId().intValue();
        }
        return checkSum;
    }

    public static Pair<FileSystemBlock[], List<File>> buildFileSystem(PuzzleInput input) {
        String line = input.getLines().get(0);
        Character[] lineAsChars = StringTools.ToCharacterArray(input.getLines().get(0));
        int totalSize = 0;
        ArrayList<File> files = new ArrayList<File>();
        for (Character lineAsChar : lineAsChars) {
            totalSize += Integer.parseInt(lineAsChar.toString());
        }
        FileSystemBlock[] fileSystem = new FileSystemBlock[totalSize];
        int placeIntFileSystem = 0;
        int fileId = 0;
        for (int i = 0; i < lineAsChars.length; ++i) {
            int j;
            int currentLineLength = Integer.parseInt(lineAsChars[i].toString());
            if (i % 2 != 0) {
                for (j = placeIntFileSystem; j < placeIntFileSystem + currentLineLength; ++j) {
                    fileSystem[j] = null;
                }
                placeIntFileSystem += currentLineLength;
                continue;
            }
            files.add(new File(placeIntFileSystem, placeIntFileSystem + currentLineLength - 1, fileId));
            for (j = placeIntFileSystem; j < placeIntFileSystem + currentLineLength; ++j) {
                fileSystem[j] = new FileSystemBlock(fileId, false);
            }
            placeIntFileSystem += currentLineLength;
            ++fileId;
        }
        return new Pair<FileSystemBlock[], List<File>>(fileSystem, files);
    }

    public static void SortFileSystem(FileSystemBlock[] fileSystem) {
        Integer lastFilled = 0;
        block0: for (int i = fileSystem.length - 1; i >= 0; --i) {
            if (fileSystem[i] == null) continue;
            if (i <= lastFilled) break;
            for (int j = 0; j < fileSystem.length; ++j) {
                if (fileSystem[j] != null) continue;
                fileSystem[j] = fileSystem[i];
                fileSystem[i] = null;
                lastFilled = j;
                continue block0;
            }
        }
    }

    public static void OverwriteNextNullWithFile(FileSystemBlock[] fileSystem, int fileLength, int fileId, int fileEnd) {
        for (int i = 0; i < fileSystem.length - fileLength; ++i) {
            int j;
            if (fileSystem[fileEnd] != null && fileSystem[fileEnd].moved) {
                return;
            }
            if (i > fileEnd) break;
            boolean valid = false;
            for (j = i; j < i + fileLength; ++j) {
                if (fileSystem[j] != null) {
                    valid = false;
                    break;
                }
                valid = true;
            }
            if (!valid) continue;
            for (j = i; j < i + fileLength; ++j) {
                fileSystem[j] = new FileSystemBlock(fileId, true);
            }
            for (j = fileEnd; j > fileEnd - fileLength; --j) {
                fileSystem[j] = null;
            }
            break;
        }
    }

    public static void SortFileSystemByFile(FileSystemBlock[] fileSystem, List<File> files) {
        int currentFileId = -1;
        int currentFileLength = 0;
        int currentFileEnd = -1;
        for (int i = fileSystem.length - 1; i >= 0; --i) {
            if (fileSystem[i] != null) {
                if (currentFileId == fileSystem[i].fileId()) {
                    ++currentFileLength;
                    continue;
                }
                if (currentFileId == -1) {
                    currentFileLength = 1;
                    currentFileId = fileSystem[i].fileId();
                    currentFileEnd = i;
                    continue;
                }
                SolutionDay9.OverwriteNextNullWithFile(fileSystem, currentFileLength, currentFileId, currentFileEnd);
                currentFileLength = 1;
                currentFileId = fileSystem[i].fileId();
                currentFileEnd = i;
                continue;
            }
            if (currentFileId == -1) continue;
            SolutionDay9.OverwriteNextNullWithFile(fileSystem, currentFileLength, currentFileId, currentFileEnd);
            currentFileLength = 0;
            currentFileId = -1;
            currentFileEnd = -1;
        }
    }

    @Override
    public Object partOne(PuzzleInput input) {
        Pair<FileSystemBlock[], List<File>> fsAndFiles = SolutionDay9.buildFileSystem(input);
        FileSystemBlock[] fs = fsAndFiles.one();
        SolutionDay9.SortFileSystem(fs);
        SolutionDay9.SortFileSystem(fs);
        return SolutionDay9.calculateCheckSum(fs);
    }

    @Override
    public Object partTwo(PuzzleInput input) {
        Pair<FileSystemBlock[], List<File>> fsAndFiles = SolutionDay9.buildFileSystem(input);
        FileSystemBlock[] fs = fsAndFiles.one();
        List<File> files = fsAndFiles.two();
        SolutionDay9.SortFileSystemByFile(fs, files);
        return SolutionDay9.calculateCheckSum(fs);
    }

    public record FileSystemBlock(Integer fileId, boolean moved) {
    }

    public record File(Integer fileStart, Integer fileEnd, Integer fileId) {
        public int length() {
            return this.fileEnd - this.fileStart + 1;
        }
    }
}

