/*
 * Decompiled with CFR 0.152.
 */
package com.expedient.adventofcodejade.solutions.year2024;

import com.expedient.adventofcodejade.BaseSolution;
import com.expedient.adventofcodejade.common.Coordinate;
import com.expedient.adventofcodejade.common.Grid;
import com.expedient.adventofcodejade.common.PuzzleInput;
import com.expedient.adventofcodejade.common.Vector2;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class SolutionDay8
extends BaseSolution {
    public SolutionDay8(PuzzleInput input, PuzzleInput sampleInputOne, PuzzleInput sampleInputTwo) {
        super(input, sampleInputOne, sampleInputTwo);
    }

    public static Map<Character, List<Coordinate>> getAntennaLists(Grid<Character> grid) {
        return grid.matchCoordinates(i -> i.charValue() != '.').stream().map(grid::at).collect(Collectors.toSet()).stream().collect(Collectors.toMap(i -> i, x -> grid.matchCoordinates(i -> i == x)));
    }

    public long getAntiNodeCount(Grid<Character> grid, Map<Character, List<Coordinate>> antennaLists, boolean partTwo) {
        HashMap antiNodes = new HashMap();
        for (Character antennaType : antennaLists.keySet()) {
            for (int i2 = 0; i2 < antennaLists.get(antennaType).size() - 1; ++i2) {
                for (int j = i2 + 1; j < antennaLists.get(antennaType).size(); ++j) {
                    Coordinate antennaOne = antennaLists.get(antennaType).get(i2);
                    Coordinate antennaTwo = antennaLists.get(antennaType).get(j);
                    for (int multiple = partTwo ? 0 : 1; multiple < (partTwo ? 100 : 2); ++multiple) {
                        Coordinate antiNodeOne = new Vector2(antennaOne, antennaTwo).multiply(multiple).reverse().apply(antennaTwo);
                        Coordinate antiNodeTwo = new Vector2(antennaTwo, antennaOne).multiply(multiple).reverse().apply(antennaOne);
                        if (!antiNodes.containsKey(antennaType) && (grid.isSafe(antiNodeOne) || grid.isSafe(antiNodeTwo))) {
                            antiNodes.put(antennaType, new HashSet());
                        }
                        if (grid.isSafe(antiNodeOne)) {
                            ((Set)antiNodes.get(antennaType)).add(antiNodeOne);
                        }
                        if (!grid.isSafe(antiNodeTwo)) continue;
                        ((Set)antiNodes.get(antennaType)).add(antiNodeTwo);
                    }
                }
            }
        }
        return antiNodes.keySet().stream().flatMap(i -> ((Set)antiNodes.get(i)).stream()).collect(Collectors.toSet()).size();
    }

    @Override
    public Long partOne(PuzzleInput input) {
        Grid<Character> grid = input.getGrid();
        return this.getAntiNodeCount(grid, SolutionDay8.getAntennaLists(grid), false);
    }

    @Override
    public Long partTwo(PuzzleInput input) {
        Grid<Character> grid = input.getGrid();
        return this.getAntiNodeCount(grid, SolutionDay8.getAntennaLists(grid), true);
    }
}

