/*
 * Decompiled with CFR 0.152.
 */
package com.expedient.adventofcodejade.solutions.year2024;

import com.expedient.adventofcodejade.BaseSolution;
import com.expedient.adventofcodejade.common.Pair;
import com.expedient.adventofcodejade.common.PuzzleInput;
import com.expedient.adventofcodejade.util.NumTools;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SolutionDay7
extends BaseSolution {
    public SolutionDay7(PuzzleInput input, PuzzleInput sampleInputOne, PuzzleInput sampleInputTwo) {
        super(input, sampleInputOne, sampleInputTwo);
    }

    public static Set<Long> apply(Set<Long> nums, Long nextOperand, Long target, boolean partTwo) {
        if (!partTwo) {
            return nums.stream().flatMap(n -> Stream.of(n * nextOperand, n + nextOperand)).filter(n -> n <= target).collect(Collectors.toSet());
        }
        return nums.stream().flatMap(n -> Stream.of(n * nextOperand, n + nextOperand, NumTools.fastCat(n, nextOperand))).filter(n -> n <= target).collect(Collectors.toSet());
    }

    public static List<Pair<Long, List<Long>>> parseInput(PuzzleInput input) {
        ArrayList<Pair<Long, List<Long>>> equations = new ArrayList<Pair<Long, List<Long>>>();
        for (String line : input.getLines()) {
            Long result = Long.parseLong(line.split(": ")[0]);
            ArrayList<Long> operands = new ArrayList<Long>();
            for (String operand : line.split(": ")[1].split(" ")) {
                operands.add(Long.parseLong(operand));
            }
            equations.add(new Pair(result, operands));
        }
        return equations;
    }

    public static boolean checkEquation(Pair<Long, List<Long>> equation, boolean partTwo) {
        Set<Long> numbers = new HashSet<Long>();
        List<Long> operands = equation.two();
        Long result = equation.one();
        numbers.add(operands.get(0));
        for (int i = 1; i < operands.size(); ++i) {
            numbers = SolutionDay7.apply(numbers, operands.get(i), result, partTwo);
        }
        return numbers.contains(result);
    }

    public static Long performRepairTask(PuzzleInput input, boolean partTwo) {
        List<Pair<Long, List<Long>>> equations = SolutionDay7.parseInput(input);
        return equations.parallelStream().filter(i -> SolutionDay7.checkEquation(i, partTwo)).map(Pair::one).reduce(Long::sum).orElseThrow();
    }

    @Override
    public Long partOne(PuzzleInput input) {
        return SolutionDay7.performRepairTask(input, false);
    }

    @Override
    public Long partTwo(PuzzleInput input) {
        return SolutionDay7.performRepairTask(input, true);
    }
}

