/*
 * Decompiled with CFR 0.152.
 */
package com.expedient.adventofcodejade.solutions.year2024;

import com.expedient.adventofcodejade.BaseSolution;
import com.expedient.adventofcodejade.common.Coordinate;
import com.expedient.adventofcodejade.common.Direction;
import com.expedient.adventofcodejade.common.Grid;
import com.expedient.adventofcodejade.common.Pair;
import com.expedient.adventofcodejade.common.PuzzleInput;
import com.expedient.adventofcodejade.util.StringTools;
import java.util.HashSet;
import java.util.Set;

public class SolutionDay6
extends BaseSolution {
    public SolutionDay6(PuzzleInput input, PuzzleInput sampleInputOne, PuzzleInput sampleInputTwo) {
        super(input, sampleInputOne, sampleInputTwo);
    }

    public static Pair<Coordinate, Direction> doStep(Grid<Character> grid, Coordinate location, Direction direction, Coordinate obstruction) {
        Coordinate newLocation = location;
        Direction newDirection = direction;
        Coordinate next = direction.next(location);
        if (!grid.isSafe(next)) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (!StringTools.isInString(grid.at(next), ".^") || next.equals(obstruction)) {
            newDirection = direction.turn();
        } else {
            newLocation = next;
        }
        return new Pair<Coordinate, Direction>(newLocation, newDirection);
    }

    public static Set<Coordinate> getAllVisitedLocations(Grid<Character> grid, Coordinate location, Direction direction) {
        HashSet<Coordinate> visited = new HashSet<Coordinate>();
        visited.add(location);
        try {
            while (true) {
                Pair<Coordinate, Direction> next = SolutionDay6.doStep(grid, location, direction, null);
                visited.add(next.one());
                location = next.one();
                direction = next.two();
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return visited;
        }
    }

    public boolean detectLoop(Grid<Character> grid, Coordinate obstruction) {
        Coordinate character = grid.matchCoordinates(i -> i.charValue() == '^').get(0);
        Direction direction = Direction.UP;
        HashSet<Pair<Coordinate, Direction>> visited = new HashSet<Pair<Coordinate, Direction>>();
        visited.add(new Pair<Coordinate, Direction>(character, direction));
        try {
            while (true) {
                Pair<Coordinate, Direction> next;
                if (visited.contains(next = SolutionDay6.doStep(grid, character, direction, obstruction))) {
                    return true;
                }
                visited.add(next);
                character = next.one();
                direction = next.two();
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return false;
        }
    }

    @Override
    public Integer partOne(PuzzleInput input) {
        Grid<Character> grid = input.getGrid();
        Coordinate character = grid.matchCoordinates(i -> i.charValue() == '^').get(0);
        Direction direction = Direction.UP;
        return SolutionDay6.getAllVisitedLocations(grid, character, direction).size();
    }

    @Override
    public Integer partTwo(PuzzleInput input) {
        Grid<Character> grid = input.getGrid();
        Coordinate character = grid.matchCoordinates(i -> i.charValue() == '^').get(0);
        Direction direction = Direction.UP;
        Set<Coordinate> visited = SolutionDay6.getAllVisitedLocations(grid, character, direction);
        int count = 0;
        for (Coordinate location : visited) {
            if (!this.detectLoop(grid, location)) continue;
            ++count;
        }
        return count;
    }
}

