/*
 * Decompiled with CFR 0.152.
 */
package com.expedient.adventofcodejade.solutions.year2024;

import com.expedient.adventofcodejade.BaseSolution;
import com.expedient.adventofcodejade.common.Pair;
import com.expedient.adventofcodejade.common.PuzzleInput;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SolutionDay5
extends BaseSolution {
    public SolutionDay5(PuzzleInput input, PuzzleInput sampleInputOne, PuzzleInput sampleInputTwo) {
        super(input, sampleInputOne, sampleInputTwo);
    }

    private Map<Integer, Pair<Set<Integer>, Set<Integer>>> getRules(List<Pair<Integer, Integer>> rules) {
        HashMap<Integer, Pair<Set<Integer>, Set<Integer>>> ruleLists = new HashMap<Integer, Pair<Set<Integer>, Set<Integer>>>();
        for (Pair<Integer, Integer> rule : rules) {
            Integer number = rule.one();
            int after = rule.two();
            if (!ruleLists.containsKey(number)) {
                ruleLists.put(number, new Pair(new HashSet(), new HashSet()));
            }
            if (!ruleLists.containsKey(after)) {
                ruleLists.put(after, new Pair(new HashSet(), new HashSet()));
            }
            ((Set)((Pair)ruleLists.get(number)).two()).add(after);
            ((Set)((Pair)ruleLists.get(after)).one()).add(number);
        }
        return ruleLists;
    }

    private List<List<Integer>> getGoodUpdates(PuzzleInput input) {
        Pair<List<Pair<Integer, Integer>>, List<List<Integer>>> lists = input.day5Input();
        List<List<Integer>> updates = lists.two();
        Map<Integer, Pair<Set<Integer>, Set<Integer>>> ruleLists = this.getRules(lists.one());
        UpdateComparator comp = new UpdateComparator(ruleLists);
        return updates.stream().filter(i -> i.stream().sorted(comp).toList().equals(i)).toList();
    }

    @Override
    public Integer partOne(PuzzleInput input) {
        List<List<Integer>> good = this.getGoodUpdates(input);
        return good.stream().map(g -> (Integer)g.get(g.size() / 2)).reduce(0, Integer::sum);
    }

    @Override
    public Integer partTwo(PuzzleInput input) {
        List<List<Integer>> good = this.getGoodUpdates(input);
        Pair<List<Pair<Integer, Integer>>, List<List<Integer>>> lists = input.day5Input();
        UpdateComparator comp = new UpdateComparator(this.getRules(lists.one()));
        return lists.two().stream().filter(i -> !good.contains(i)).map(i -> i.stream().sorted(comp).toList()).map(i -> (Integer)i.get(i.size() / 2)).reduce(Integer::sum).orElseThrow(IllegalArgumentException::new);
    }

    private record UpdateComparator(Map<Integer, Pair<Set<Integer>, Set<Integer>>> rules) implements Comparator<Integer>
    {
        @Override
        public int compare(Integer o1, Integer o2) {
            if (this.rules.containsKey(o1)) {
                if (this.rules.get(o1).two().contains(o2)) {
                    return -1;
                }
                if (this.rules.get(o1).one().contains(o2)) {
                    return 1;
                }
            } else if (this.rules.containsKey(o2)) {
                if (this.rules.get(o2).two().contains(o1)) {
                    return 1;
                }
                if (this.rules.get(o2).one().contains(o1)) {
                    return -1;
                }
            }
            return 0;
        }
    }
}

