/*
 * Decompiled with CFR 0.152.
 */
package com.expedient.adventofcodejade.solutions.year2024;

import com.expedient.adventofcodejade.BaseSolution;
import com.expedient.adventofcodejade.common.Coordinate;
import com.expedient.adventofcodejade.common.Grid;
import com.expedient.adventofcodejade.common.PuzzleInput;
import java.util.List;

public class SolutionDay4
extends BaseSolution {
    public SolutionDay4(PuzzleInput input, PuzzleInput sampleInputOne, PuzzleInput sampleInputTwo) {
        super(input, sampleInputOne, sampleInputTwo);
    }

    @Override
    public Integer partOne(PuzzleInput input) {
        Grid<Character> wordSearch = input.getGrid();
        List<Coordinate> starts = wordSearch.matchCoordinates(i -> i.charValue() == 'X');
        int count = 0;
        for (Coordinate start : starts) {
            List<Coordinate> potentials = wordSearch.matchNeighbors(start, i -> i.charValue() == 'M');
            for (Coordinate potential : potentials) {
                try {
                    Coordinate sLetter;
                    Coordinate aLetter = start.nextInDirection(potential);
                    if (wordSearch.at(aLetter).charValue() != 'A' || wordSearch.at(sLetter = potential.nextInDirection(aLetter)).charValue() != 'S') continue;
                    ++count;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
            }
        }
        return count;
    }

    @Override
    public Integer partTwo(PuzzleInput input) {
        Grid<Character> wordSearch = input.getGrid();
        List<Coordinate> starts = wordSearch.matchCoordinates(i -> i.charValue() == 'A');
        int count = 0;
        for (Coordinate start : starts) {
            List<Coordinate> potentials = wordSearch.matchNeighbors(start, i -> i.charValue() == 'M');
            potentials = potentials.stream().filter(x -> !x.isOrthogonal(start)).toList();
            boolean found = false;
            for (Coordinate potential : potentials) {
                try {
                    Coordinate sLetter = start.inOppositeDirection(potential);
                    if (wordSearch.at(sLetter).charValue() != 'S') continue;
                    if (found) {
                        ++count;
                        continue;
                    }
                    found = true;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
            }
        }
        return count;
    }
}

