/*
 * Decompiled with CFR 0.152.
 */
package com.expedient.adventofcodejade.solutions.year2024;

import com.expedient.adventofcodejade.BaseSolution;
import com.expedient.adventofcodejade.common.PuzzleInput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.SequencedCollection;
import java.util.Set;

public class SolutionDay24
extends BaseSolution {
    public SolutionDay24(PuzzleInput input, PuzzleInput sampleInputOne, PuzzleInput sampleInputTwo) {
        super(input, sampleInputOne, sampleInputTwo);
    }

    @Override
    public Object partOne(PuzzleInput input) {
        List<String> lines = input.getLines();
        HashMap<String, Boolean> initialStates = new HashMap<String, Boolean>();
        int blankLineIdx = 0;
        for (int i2 = 0; i2 < lines.size(); ++i2) {
            if (lines.get(i2).isBlank()) {
                blankLineIdx = i2;
                break;
            }
            String gateName = lines.get(i2).split(": ")[0];
            boolean gateValue = Objects.equals(lines.get(i2).split(": ")[1], "1");
            initialStates.put(gateName, gateValue);
        }
        LinkedList<Connection> connections = new LinkedList<Connection>();
        for (int i3 = blankLineIdx + 1; i3 < lines.size(); ++i3) {
            String[] split = lines.get(i3).split(" ");
            String gateOneName = split[0];
            String connectionName = split[1];
            String gateTwoName = split[2];
            String outputGateName = split[4];
            if (!initialStates.containsKey(outputGateName)) {
                initialStates.put(outputGateName, null);
            }
            Relationship r = switch (connectionName) {
                case "XOR" -> Relationship.XOR;
                case "AND" -> Relationship.AND;
                case "OR" -> Relationship.OR;
                default -> throw new RuntimeException();
            };
            connections.add(new Connection(List.of(gateOneName, gateTwoName), r, outputGateName));
        }
        while (!connections.isEmpty()) {
            Connection conn = (Connection)connections.poll();
            if (conn.inputGates.stream().anyMatch(n -> initialStates.get(n) == null)) {
                connections.add(conn);
                continue;
            }
            boolean result = switch (conn.relationship.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    if (((Boolean)initialStates.get(conn.inputGates.get(0))).booleanValue() || ((Boolean)initialStates.get(conn.inputGates.get(1))).booleanValue()) {
                        yield true;
                    }
                    yield false;
                }
                case 1 -> (Boolean)initialStates.get(conn.inputGates.get(0)) ^ (Boolean)initialStates.get(conn.inputGates.get(1));
                case 2 -> (Boolean)initialStates.get(conn.inputGates.get(0)) != false && (Boolean)initialStates.get(conn.inputGates.get(1)) != false;
            };
            initialStates.put(conn.outputGate, result);
        }
        SequencedCollection sorted = initialStates.keySet().stream().sorted().filter(i -> i.startsWith("z")).toList().reversed();
        StringBuilder sb = new StringBuilder();
        for (String s : sorted) {
            sb.append((Boolean)initialStates.get(s) != false ? "1" : "0");
        }
        return Long.parseLong(sb.toString(), 2);
    }

    @Override
    public Object partTwo(PuzzleInput input) {
        if (input.isTest()) {
            return "SKIPPED: Solution not available with test inputs";
        }
        List<String> lines = input.getLines();
        HashMap<String, Boolean> initialStates = new HashMap<String, Boolean>();
        int blankLineIdx = 0;
        for (int i = 0; i < lines.size(); ++i) {
            if (lines.get(i).isBlank()) {
                blankLineIdx = i;
                break;
            }
            String gateName = lines.get(i).split(": ")[0];
            boolean gateValue = Objects.equals(lines.get(i).split(": ")[1], "1");
            initialStates.put(gateName, gateValue);
        }
        ArrayList<Connection> connections = new ArrayList<Connection>();
        HashMap<Set<String>, String> xorConnections = new HashMap<Set<String>, String>();
        HashMap<Set<String>, String> andConnections = new HashMap<Set<String>, String>();
        HashMap<Set<String>, String> orConnections = new HashMap<Set<String>, String>();
        for (int i = blankLineIdx + 1; i < lines.size(); ++i) {
            String[] split = lines.get(i).split(" ");
            String gateOneName = split[0];
            String connectionName = split[1];
            String gateTwoName = split[2];
            String outputGateName = split[4];
            Relationship r = switch (connectionName) {
                case "XOR" -> {
                    xorConnections.put(Set.of(gateOneName, gateTwoName), outputGateName);
                    yield Relationship.XOR;
                }
                case "AND" -> {
                    andConnections.put(Set.of(gateOneName, gateTwoName), outputGateName);
                    yield Relationship.AND;
                }
                case "OR" -> {
                    orConnections.put(Set.of(gateOneName, gateTwoName), outputGateName);
                    yield Relationship.OR;
                }
                default -> throw new RuntimeException();
            };
            connections.add(new Connection(List.of(gateOneName, gateTwoName), r, outputGateName));
        }
        ArrayList<HalfAdder> halfAdders = new ArrayList<HalfAdder>();
        for (int i = 0; i < 100; ++i) {
            String num = String.format("%02d", i);
            if (!initialStates.containsKey("x" + num) || !initialStates.containsKey("y" + num)) continue;
            String sumOut = (String)xorConnections.get(Set.of("x" + num, "y" + num));
            String carryOut = (String)andConnections.get(Set.of("x" + num, "y" + num));
            halfAdders.add(new HalfAdder(Set.of("x" + num, "y" + num), sumOut, carryOut));
        }
        ArrayList<Output> outputs = new ArrayList<Output>();
        ArrayList<Object> investigate = new ArrayList<Object>();
        for (int i = 0; i < halfAdders.size(); ++i) {
            String num = String.format("%02d", i);
            HalfAdder halfAdder = (HalfAdder)halfAdders.get(i);
            try {
                Set conn = xorConnections.keySet().stream().filter(k -> ((String)xorConnections.get(k)).equals("z" + num)).findFirst().orElseThrow();
                outputs.add(new Output(conn, "z" + num));
                if (conn.contains(halfAdder.sumWire) || i == 0) continue;
                investigate.add("z" + num);
                investigate.add(halfAdder.sumWire);
                continue;
            }
            catch (NoSuchElementException e) {
                String sumWire = (String)xorConnections.get(Set.of("x" + num, "y" + num));
                investigate.add("z" + num);
                investigate.add(sumWire);
            }
        }
        return "Investigate the following wires manually in the input: " + String.valueOf(investigate);
    }

    public static enum Relationship {
        OR,
        XOR,
        AND;

    }

    public record Connection(List<String> inputGates, Relationship relationship, String outputGate) {
    }

    public record HalfAdder(Set<String> inputs, String sumWire, String carryWire) {
    }

    public record Output(Set<String> inputs, String outputWire) {
    }
}

