/*
 * Decompiled with CFR 0.152.
 */
package com.expedient.adventofcodejade.solutions.year2024;

import com.expedient.adventofcodejade.BaseSolution;
import com.expedient.adventofcodejade.common.PuzzleInput;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class SolutionDay23
extends BaseSolution {
    public SolutionDay23(PuzzleInput input, PuzzleInput sampleInputOne, PuzzleInput sampleInputTwo) {
        super(input, sampleInputOne, sampleInputTwo);
    }

    public boolean hasThreeInCommon(Set<String> one, Set<String> two) {
        boolean found = one.stream().filter(two::contains).count() >= 3L;
        return found;
    }

    public Set<String> threeThatAreInCommon(Set<String> one, Set<String> two, Set<String> three) {
        HashSet<String> newSet = new HashSet<String>();
        for (String s : one) {
            if (!two.contains(s) || !three.contains(s)) continue;
            newSet.add(s);
        }
        return newSet;
    }

    @Override
    public Object partOne(PuzzleInput input) {
        HashSet<Set<String>> connections = new HashSet<Set<String>>();
        for (String string : input.getLines()) {
            String string2 = string.split("-")[0];
            String string3 = string.split("-")[1];
            connections.add(Set.of(string2, string3));
        }
        HashSet networks = new HashSet();
        for (Set set : connections) {
            for (Set set2 : connections) {
                if (set.equals(set2) || set.stream().noneMatch(x -> j.contains(x))) continue;
                HashSet network = new HashSet();
                network.addAll(set);
                network.addAll(set2);
                networks.add(network);
            }
        }
        HashSet<Set> hashSet = new HashSet<Set>();
        for (Set set : networks) {
            if (connections.stream().filter(i -> network.containsAll((Collection<?>)i)).count() < 3L) continue;
            hashSet.add(set);
        }
        return hashSet.stream().filter(s -> s.stream().anyMatch(i -> i.startsWith("t"))).count();
    }

    @Override
    public Object partTwo(PuzzleInput input) {
        HashMap connections = new HashMap();
        for (String line : input.getLines()) {
            String pc = line.split("-")[0];
            String other = line.split("-")[1];
            if (!connections.containsKey(pc)) {
                connections.put(pc, new HashSet());
            }
            if (!connections.containsKey(other)) {
                connections.put(other, new HashSet());
            }
            ((Set)connections.get(other)).add(pc);
            ((Set)connections.get(pc)).add(other);
        }
        HashSet largestClique = new HashSet();
        for (String current : connections.keySet()) {
            HashSet<String> clique = new HashSet<String>();
            clique.add(current);
            for (String key : connections.keySet()) {
                if (!((Set)connections.get(key)).containsAll(clique)) continue;
                clique.add(key);
            }
            if (clique.size() <= largestClique.size()) continue;
            largestClique = clique;
        }
        return largestClique.stream().sorted().collect(Collectors.joining(","));
    }
}

