/*
 * Decompiled with CFR 0.152.
 */
package com.expedient.adventofcodejade.solutions.year2024;

import com.expedient.adventofcodejade.BaseSolution;
import com.expedient.adventofcodejade.common.PuzzleInput;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class SolutionDay22
extends BaseSolution {
    public SolutionDay22(PuzzleInput input, PuzzleInput sampleInputOne, PuzzleInput sampleInputTwo) {
        super(input, sampleInputOne, sampleInputTwo);
    }

    public static long mix(Long one, Long two) {
        return one ^ two;
    }

    public static long prune(Long num) {
        return num % 0x1000000L;
    }

    public static long calculateNext(long num) {
        long newNum = SolutionDay22.prune(SolutionDay22.mix(num * 64L, num));
        newNum = SolutionDay22.prune(SolutionDay22.mix(newNum / 32L, newNum));
        newNum = SolutionDay22.prune(SolutionDay22.mix(newNum * 2048L, newNum));
        return newNum;
    }

    @Override
    public Object partOne(PuzzleInput input) {
        long total = 0L;
        for (Long num : input.getLines().stream().map(Long::parseLong).toList()) {
            for (int i = 0; i < 2000; ++i) {
                num = SolutionDay22.calculateNext(num);
            }
            total += num.longValue();
        }
        return total;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object partTwo(PuzzleInput input) {
        ArrayList pricesList = new ArrayList();
        for (Long l : input.getLines().stream().map(Long::parseLong).toList()) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            arrayList.add((int)(l % 10L));
            for (int i = 0; i < 2000; ++i) {
                void var4_4;
                Long l2 = SolutionDay22.calculateNext(var4_4.longValue());
                arrayList.add((int)(l2 % 10L));
            }
            pricesList.add(arrayList);
        }
        HashMap<PriceChanges, Integer> changes = new HashMap<PriceChanges, Integer>();
        for (List list : pricesList) {
            HashSet<PriceChanges> found = new HashSet<PriceChanges>();
            for (int i = 0; i < 1997; ++i) {
                int one = (Integer)list.get(i + 1) - (Integer)list.get(i);
                int two = (Integer)list.get(i + 2) - (Integer)list.get(i + 1);
                int three = (Integer)list.get(i + 3) - (Integer)list.get(i + 2);
                int four = (Integer)list.get(i + 4) - (Integer)list.get(i + 3);
                PriceChanges c = new PriceChanges(one, two, three, four);
                if (found.contains(c)) continue;
                found.add(c);
                if (!changes.containsKey(c)) {
                    changes.put(c, 0);
                }
                changes.put(c, changes.get(c) + (Integer)list.get(i + 4));
            }
        }
        PriceChangesComparator priceChangesComparator = new PriceChangesComparator(changes);
        return changes.get(changes.keySet().stream().sorted(priceChangesComparator).toList().getLast());
    }

    public record PriceChanges(Integer one, Integer two, Integer three, Integer four) {
    }

    public static class PriceChangesComparator
    implements Comparator<PriceChanges> {
        private final Map<PriceChanges, Integer> changesMap;

        public PriceChangesComparator(Map<PriceChanges, Integer> changesMap) {
            this.changesMap = changesMap;
        }

        @Override
        public int compare(PriceChanges o1, PriceChanges o2) {
            int totalOne = this.changesMap.get(o1);
            int totalTwo = this.changesMap.get(o2);
            return Integer.compare(totalOne, totalTwo);
        }
    }
}

