/*
 * Decompiled with CFR 0.152.
 */
package com.expedient.adventofcodejade.solutions.year2024;

import com.expedient.adventofcodejade.BaseSolution;
import com.expedient.adventofcodejade.common.Pair;
import com.expedient.adventofcodejade.common.PuzzleInput;
import com.expedient.adventofcodejade.util.StringTools;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;

public class SolutionDay21
extends BaseSolution {
    public SolutionDay21(PuzzleInput input, PuzzleInput sampleInputOne, PuzzleInput sampleInputTwo) {
        super(input, sampleInputOne, sampleInputTwo);
    }

    public static void printInputList(List<Input> inputs) {
        for (Input input : inputs) {
            char ch = switch (input.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> '^';
                case 1 -> 'v';
                case 2 -> '<';
                case 3 -> '>';
                case 4 -> 'A';
            };
            System.out.print(ch);
        }
        System.out.println("");
    }

    @Override
    public Object partOne(PuzzleInput input) {
        List<String> lines = input.getLines();
        int total = 0;
        NumberPad numberPad = new NumberPad(this);
        DirectionalPad firstDirectionalPad = new DirectionalPad(this);
        DirectionalPad secondDirectionalPad = new DirectionalPad(this);
        for (String line : lines) {
            ArrayList<Input> allIns = new ArrayList<Input>();
            int num = Integer.parseInt(line.substring(0, 3));
            for (Character c : StringTools.ToCharacterArray(line)) {
                List<Input> numPadInputs = numberPad.pressButton(c);
                for (Input d1 : numPadInputs) {
                    List<Input> d1PadInputs = firstDirectionalPad.fromInput(d1);
                    for (Input d2 : d1PadInputs) {
                        allIns.addAll(secondDirectionalPad.fromInput(d2));
                    }
                }
            }
            total += num * allIns.size();
        }
        return total;
    }

    @Override
    public Object partTwo(PuzzleInput input) {
        List<String> lines = input.getLines();
        long total = 0L;
        NumberPad numberPad = new NumberPad(this);
        int numDPads = 1;
        ArrayList<DirectionalPad> dPads = new ArrayList<DirectionalPad>();
        for (int i = 0; i < numDPads; ++i) {
            dPads.add(new DirectionalPad(this));
        }
        PriorityQueue<PadTask> padTasks = new PriorityQueue<PadTask>(new PadTaskComparator(this));
        for (String line : lines) {
            long t = 0L;
            int num = Integer.parseInt(line.substring(0, 3));
            for (Character c : StringTools.ToCharacterArray(line)) {
                List<Input> numPadInputs = numberPad.pressButton(c);
                for (Input numPadInput : numPadInputs) {
                    padTasks.add(new PadTask(numPadInput, 0));
                    while (!padTasks.isEmpty()) {
                        PadTask task = padTasks.poll();
                        if (task.padDepth < numDPads) {
                            List<Input> result = ((DirectionalPad)dPads.get(task.padDepth)).fromInput(task.input);
                            for (int i = result.size() - 1; i >= 0; --i) {
                                padTasks.add(new PadTask(result.get(i), task.padDepth + 1));
                            }
                            continue;
                        }
                        ++t;
                    }
                }
                total += t * (long)num;
            }
        }
        return null;
    }

    public static enum Input {
        UP,
        DOWN,
        LEFT,
        RIGHT,
        ENTER;

    }

    public class NumberPad {
        private static Character[][] nums = new Character[][]{{Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9')}, {Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6')}, {Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3')}, {null, Character.valueOf('0'), Character.valueOf('A')}};
        private List<Input> currentInputs = new ArrayList<Input>();
        private int currentCol = 2;
        private int currentRow = 3;
        private Input lastRequested = null;

        public NumberPad(SolutionDay21 this$0) {
        }

        public Pair<Integer, Integer> findButton(Character button) {
            for (int row = 0; row < nums.length; ++row) {
                for (int col = 0; col < nums[row].length; ++col) {
                    if (nums[row][col] != button) continue;
                    return new Pair<Integer, Integer>(row, col);
                }
            }
            throw new RuntimeException();
        }

        public void checkValid() {
            if (this.currentRow < 0 || this.currentRow > nums.length) {
                throw new RuntimeException();
            }
            if (this.currentCol < 0 || this.currentCol > nums[this.currentRow].length) {
                throw new RuntimeException();
            }
            if (nums[this.currentRow][this.currentCol] == null) {
                throw new RuntimeException();
            }
        }

        public void moveUp() {
            --this.currentRow;
            this.checkValid();
            this.currentInputs.add(Input.UP);
            this.lastRequested = Input.UP;
        }

        public void moveDown() {
            ++this.currentRow;
            this.checkValid();
            this.currentInputs.add(Input.DOWN);
            this.lastRequested = Input.DOWN;
        }

        public void moveLeft() {
            --this.currentCol;
            this.checkValid();
            this.currentInputs.add(Input.LEFT);
            this.lastRequested = Input.LEFT;
        }

        public void moveRight() {
            ++this.currentCol;
            this.checkValid();
            this.currentInputs.add(Input.RIGHT);
            this.lastRequested = Input.RIGHT;
        }

        public List<Input> pressButton(Character desiredButton) {
            Pair<Integer, Integer> location = this.findButton(desiredButton);
            int virtualRow = this.currentRow;
            int virtualCol = this.currentCol;
            ArrayList<Input> inputQueue = new ArrayList<Input>();
            while (nums[virtualRow][virtualCol] != desiredButton) {
                if (nums[virtualRow][location.two()] != null) {
                    while (virtualCol > location.two()) {
                        inputQueue.add(Input.LEFT);
                        --virtualCol;
                    }
                }
                while (virtualRow > location.one()) {
                    inputQueue.add(Input.UP);
                    --virtualRow;
                }
                while (virtualRow < location.one()) {
                    inputQueue.add(Input.DOWN);
                    ++virtualRow;
                }
                while (virtualCol < location.two()) {
                    inputQueue.add(Input.RIGHT);
                    ++virtualCol;
                }
            }
            PriorityQueue<Input> sortedInputs = new PriorityQueue<Input>(new InputComparator(null));
            sortedInputs.addAll(inputQueue);
            while (!sortedInputs.isEmpty()) {
                switch (sortedInputs.poll().ordinal()) {
                    case 1: {
                        this.moveDown();
                        break;
                    }
                    case 2: {
                        this.moveLeft();
                        break;
                    }
                    case 3: {
                        this.moveRight();
                        break;
                    }
                    case 0: {
                        this.moveUp();
                        break;
                    }
                }
                PriorityQueue<Input> x = new PriorityQueue<Input>(new InputComparator(this.lastRequested));
                x.addAll(sortedInputs);
                sortedInputs = x;
            }
            this.currentInputs.add(Input.ENTER);
            List<Input> ins = this.currentInputs;
            this.currentInputs = new ArrayList<Input>();
            this.lastRequested = null;
            return ins;
        }

        private class InputComparator
        implements Comparator<Input> {
            private Input lastInserted;

            public InputComparator(Input lastInserted) {
                this.lastInserted = lastInserted;
            }

            @Override
            public int compare(Input o1, Input o2) {
                if (o1.equals((Object)Input.LEFT) && nums[NumberPad.this.currentRow][NumberPad.this.currentCol - 1] == null) {
                    return 1;
                }
                if (o2.equals((Object)Input.LEFT) && nums[NumberPad.this.currentRow][NumberPad.this.currentCol - 1] == null) {
                    return -1;
                }
                if (o1.equals((Object)Input.DOWN) && nums[NumberPad.this.currentRow + 1][NumberPad.this.currentCol] == null) {
                    return 1;
                }
                if (o2.equals((Object)Input.DOWN) && nums[NumberPad.this.currentRow + 1][NumberPad.this.currentCol] == null) {
                    return -1;
                }
                if (o1.equals((Object)NumberPad.this.lastRequested)) {
                    return -1;
                }
                if (o2.equals((Object)NumberPad.this.lastRequested)) {
                    return 1;
                }
                return 0;
            }
        }
    }

    public class DirectionalPad {
        private static Character[][] dirs = new Character[][]{{null, Character.valueOf('^'), Character.valueOf('A')}, {Character.valueOf('<'), Character.valueOf('v'), Character.valueOf('>')}};
        private List<Input> currentInputs = new ArrayList<Input>();
        private int currentCol = 2;
        private int currentRow = 0;
        private Input lastRequested = null;

        public DirectionalPad(SolutionDay21 this$0) {
        }

        public Character getCurrentSelected() {
            return dirs[this.currentRow][this.currentCol];
        }

        public Pair<Integer, Integer> findButton(Character button) {
            for (int row = 0; row < dirs.length; ++row) {
                for (int col = 0; col < dirs[row].length; ++col) {
                    if (dirs[row][col] != button) continue;
                    return new Pair<Integer, Integer>(row, col);
                }
            }
            throw new RuntimeException();
        }

        public void checkValid() {
            if (this.currentRow < 0 || this.currentRow > dirs.length) {
                throw new RuntimeException();
            }
            if (this.currentCol < 0 || this.currentCol > dirs[this.currentRow].length) {
                throw new RuntimeException();
            }
            if (dirs[this.currentRow][this.currentCol] == null) {
                throw new RuntimeException();
            }
        }

        public void moveUp() {
            --this.currentRow;
            this.checkValid();
            this.currentInputs.add(Input.UP);
            this.lastRequested = Input.UP;
        }

        public void moveDown() {
            ++this.currentRow;
            this.checkValid();
            this.currentInputs.add(Input.DOWN);
            this.lastRequested = Input.DOWN;
        }

        public void moveLeft() {
            --this.currentCol;
            this.checkValid();
            this.currentInputs.add(Input.LEFT);
            this.lastRequested = Input.LEFT;
        }

        public void moveRight() {
            ++this.currentCol;
            this.checkValid();
            this.currentInputs.add(Input.RIGHT);
            this.lastRequested = Input.RIGHT;
        }

        public List<Input> pressButton(Character desiredButton) {
            Pair<Integer, Integer> location = this.findButton(desiredButton);
            int virtualRow = this.currentRow;
            int virtualCol = this.currentCol;
            ArrayList<Input> inputQueue = new ArrayList<Input>();
            while (dirs[virtualRow][virtualCol] != desiredButton) {
                while (virtualRow > location.one() && dirs[virtualRow - 1][virtualCol] != null) {
                    inputQueue.add(Input.UP);
                    --virtualRow;
                }
                while (virtualRow < location.one()) {
                    inputQueue.add(Input.DOWN);
                    ++virtualRow;
                }
                while (virtualCol > location.two() && dirs[virtualRow][virtualCol - 1] != null) {
                    inputQueue.add(Input.LEFT);
                    --virtualCol;
                }
                while (virtualCol < location.two()) {
                    inputQueue.add(Input.RIGHT);
                    ++virtualCol;
                }
            }
            PriorityQueue<Input> sortedInputs = new PriorityQueue<Input>(new InputComparator());
            sortedInputs.addAll(inputQueue);
            while (!sortedInputs.isEmpty()) {
                switch (sortedInputs.poll().ordinal()) {
                    case 1: {
                        this.moveDown();
                        break;
                    }
                    case 2: {
                        this.moveLeft();
                        break;
                    }
                    case 3: {
                        this.moveRight();
                        break;
                    }
                    case 0: {
                        this.moveUp();
                        break;
                    }
                }
                PriorityQueue<Input> x = new PriorityQueue<Input>(new InputComparator());
                x.addAll(sortedInputs);
                sortedInputs = x;
            }
            this.currentInputs.add(Input.ENTER);
            List<Input> ins = this.currentInputs;
            this.currentInputs = new ArrayList<Input>();
            return ins;
        }

        public List<Input> fromInput(Input input) {
            char ch = switch (input.ordinal()) {
                default -> throw new MatchException(null, null);
                case 1 -> 'v';
                case 2 -> '<';
                case 0 -> '^';
                case 3 -> '>';
                case 4 -> 'A';
            };
            return this.pressButton(Character.valueOf(ch));
        }

        private class InputComparator
        implements Comparator<Input> {
            private InputComparator() {
            }

            @Override
            public int compare(Input o1, Input o2) {
                if (o1.equals((Object)Input.LEFT) && dirs[DirectionalPad.this.currentRow][DirectionalPad.this.currentCol - 1] == null) {
                    return 1;
                }
                if (o2.equals((Object)Input.LEFT) && dirs[DirectionalPad.this.currentRow][DirectionalPad.this.currentCol - 1] == null) {
                    return -1;
                }
                if (o1.equals((Object)Input.UP) && dirs[DirectionalPad.this.currentRow - 1][DirectionalPad.this.currentCol] == null) {
                    return 1;
                }
                if (o2.equals((Object)Input.UP) && dirs[DirectionalPad.this.currentRow - 1][DirectionalPad.this.currentCol] == null) {
                    return -1;
                }
                if (o1.equals((Object)DirectionalPad.this.lastRequested)) {
                    return -1;
                }
                if (o2.equals((Object)DirectionalPad.this.lastRequested)) {
                    return 1;
                }
                return 0;
            }
        }
    }

    public class PadTaskComparator
    implements Comparator<PadTask> {
        public PadTaskComparator(SolutionDay21 this$0) {
        }

        @Override
        public int compare(PadTask o1, PadTask o2) {
            return o1.padDepth.compareTo(o2.padDepth);
        }
    }

    public record PadTask(Input input, Integer padDepth) {
    }
}

