/*
 * Decompiled with CFR 0.152.
 */
package com.expedient.adventofcodejade.solutions.year2024;

import com.expedient.adventofcodejade.BaseSolution;
import com.expedient.adventofcodejade.common.Coordinate;
import com.expedient.adventofcodejade.common.Grid;
import com.expedient.adventofcodejade.common.PuzzleInput;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class SolutionDay20
extends BaseSolution {
    public SolutionDay20(PuzzleInput input, PuzzleInput sampleInputOne, PuzzleInput sampleInputTwo) {
        super(input, sampleInputOne, sampleInputTwo);
    }

    public Map<Coordinate, Integer> traverseMaze(Grid<Character> grid) {
        HashMap<Coordinate, Integer> mazePath = new HashMap<Coordinate, Integer>();
        Coordinate currentCoordinate = grid.matchCoordinates(c -> c.charValue() == 'S').getFirst();
        Coordinate endCoordinate = grid.matchCoordinates(c -> c.charValue() == 'E').getFirst();
        mazePath.put(currentCoordinate, 0);
        int total = 0;
        HashSet<Coordinate> visited = new HashSet<Coordinate>();
        while (!currentCoordinate.equals(endCoordinate)) {
            visited.add(currentCoordinate);
            currentCoordinate = grid.matchNeighbors(currentCoordinate, c -> c.charValue() != '#', true).stream().filter(c -> !visited.contains(c)).findFirst().orElseThrow();
            mazePath.put(currentCoordinate, ++total);
        }
        return mazePath;
    }

    public int findCheats(Grid<Character> maze, Map<Coordinate, Integer> mazePath, int magnitude, int cheatLength) {
        List<Coordinate> startPoints = maze.matchCoordinates(c -> c.charValue() == '.' || c.charValue() == 'S' || c.charValue() == 'E');
        HashSet cheats = new HashSet(mazePath.size() * 2);
        for (Coordinate startPoint : startPoints) {
            int startDistance = mazePath.get(startPoint);
            cheats.addAll(maze.coordinatesWithinTaxicabDistance(startPoint, cheatLength, c -> c.charValue() != '#').stream().filter(c -> {
                Integer endDistance = (Integer)mazePath.get(c);
                int dist = startPoint.taxiCabDistance((Coordinate)c);
                if (endDistance == null) {
                    return false;
                }
                int Saved = Math.abs(startDistance - endDistance) - dist;
                return dist <= cheatLength && Saved >= magnitude;
            }).map(c -> Set.of(startPoint, c)).collect(Collectors.toSet()));
        }
        return cheats.size();
    }

    @Override
    public Integer partOne(PuzzleInput input) {
        Grid<Character> grid = input.getGrid();
        Map<Coordinate, Integer> mazePath = this.traverseMaze(input.getGrid());
        int magnitude = input.isTest() ? 2 : 100;
        return this.findCheats(grid, mazePath, magnitude, 2);
    }

    @Override
    public Integer partTwo(PuzzleInput input) {
        Grid<Character> grid = input.getGrid();
        Map<Coordinate, Integer> mazePath = this.traverseMaze(input.getGrid());
        int magnitude = input.isTest() ? 50 : 100;
        return this.findCheats(grid, mazePath, magnitude, 20);
    }
}

