/*
 * Decompiled with CFR 0.152.
 */
package com.expedient.adventofcodejade.solutions.year2024;

import com.expedient.adventofcodejade.BaseSolution;
import com.expedient.adventofcodejade.common.PuzzleInput;
import java.util.Arrays;
import java.util.List;

public class SolutionDay2
extends BaseSolution {
    public SolutionDay2(PuzzleInput input, PuzzleInput sampleInputOne, PuzzleInput sampleInputTwo) {
        super(input, sampleInputOne, sampleInputTwo);
    }

    public static boolean testAllIterationsOfReport(List<Integer> nums) {
        for (int i = 0; i < nums.size(); ++i) {
            if (!SolutionDay2.isGoodReport(nums, i)) continue;
            return true;
        }
        return false;
    }

    public static boolean isGoodReport(List<Integer> nums) {
        return SolutionDay2.isGoodReport(nums, -1);
    }

    public static boolean isGoodReport(List<Integer> nums, int excludeIndex) {
        int lastNum = nums.get(0);
        int startIndex = 1;
        boolean isIncreasing = true;
        boolean isDecreasing = true;
        if (excludeIndex == 0) {
            lastNum = nums.get(1);
            ++startIndex;
        }
        for (int i = startIndex; i < nums.size(); ++i) {
            if (i == excludeIndex) continue;
            int diff = Math.abs(nums.get(i) - lastNum);
            if (nums.get(i) < lastNum) {
                isIncreasing = false;
            }
            if (nums.get(i) > lastNum) {
                isDecreasing = false;
            }
            if (diff > 3 || diff < 1) {
                return false;
            }
            lastNum = nums.get(i);
        }
        return isIncreasing || isDecreasing;
    }

    @Override
    public Integer partOne(PuzzleInput inputUsed) {
        List<String> lines = inputUsed.getLines();
        int goodReports = 0;
        for (String line : lines) {
            List<Integer> splitLine = Arrays.stream(line.split(" ")).map(Integer::parseInt).toList();
            if (!SolutionDay2.isGoodReport(splitLine)) continue;
            ++goodReports;
        }
        return goodReports;
    }

    @Override
    public Integer partTwo(PuzzleInput inputUsed) {
        List<String> lines = inputUsed.getLines();
        int goodReports = 0;
        for (String line : lines) {
            List<Integer> splitLine = Arrays.stream(line.split(" ")).map(Integer::parseInt).toList();
            if (SolutionDay2.isGoodReport(splitLine)) {
                ++goodReports;
                continue;
            }
            if (!SolutionDay2.testAllIterationsOfReport(splitLine)) continue;
            ++goodReports;
        }
        return goodReports;
    }
}

