/*
 * Decompiled with CFR 0.152.
 */
package com.expedient.adventofcodejade.solutions.year2024;

import com.expedient.adventofcodejade.BaseSolution;
import com.expedient.adventofcodejade.common.PuzzleInput;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class SolutionDay19
extends BaseSolution {
    public SolutionDay19(PuzzleInput input, PuzzleInput sampleInputOne, PuzzleInput sampleInputTwo) {
        super(input, sampleInputOne, sampleInputTwo);
    }

    public long numberOfWaysToConstruct(String pattern, List<String> rugs) {
        long[] waysToConstructAtLength = new long[pattern.length() + 1];
        waysToConstructAtLength[0] = 1L;
        for (int i = 0; i < pattern.length(); ++i) {
            if (waysToConstructAtLength[i] == 0L) continue;
            for (String rug : rugs) {
                if (!pattern.regionMatches(i, rug, 0, rug.length())) continue;
                int n = i + rug.length();
                waysToConstructAtLength[n] = waysToConstructAtLength[n] + waysToConstructAtLength[i];
            }
        }
        return waysToConstructAtLength[pattern.length()];
    }

    @Override
    public Object partOne(PuzzleInput input) {
        List<String> listOfRugs = Arrays.stream(input.getLines().get(0).split(", ")).sorted(Comparator.comparingInt(String::length)).map(String::trim).toList();
        List<String> listOfPatterns = input.getLines().subList(2, input.getLines().size());
        long total = 0L;
        for (String line : listOfPatterns) {
            total += this.numberOfWaysToConstruct(line, listOfRugs) > 0L ? 1L : 0L;
        }
        return total;
    }

    @Override
    public Object partTwo(PuzzleInput input) {
        List<String> listOfRugs = Arrays.stream(input.getLines().get(0).split(", ")).sorted(Comparator.comparingInt(String::length)).map(String::trim).toList();
        List<String> listOfPatterns = input.getLines().subList(2, input.getLines().size());
        long total = 0L;
        for (String line : listOfPatterns) {
            total += this.numberOfWaysToConstruct(line, listOfRugs);
        }
        return total;
    }
}

