/*
 * Decompiled with CFR 0.152.
 */
package com.expedient.adventofcodejade.solutions.year2024;

import com.expedient.adventofcodejade.BaseSolution;
import com.expedient.adventofcodejade.common.Coordinate;
import com.expedient.adventofcodejade.common.Grid;
import com.expedient.adventofcodejade.common.Pair;
import com.expedient.adventofcodejade.common.PuzzleInput;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;

public class SolutionDay18
extends BaseSolution {
    public SolutionDay18(PuzzleInput input, PuzzleInput sampleInputOne, PuzzleInput sampleInputTwo) {
        super(input, sampleInputOne, sampleInputTwo);
    }

    public static boolean isTraversable(Character c) {
        return c.charValue() != '#';
    }

    public static List<Pair<Coordinate, Integer>> getNeighbors(Grid<Character> grid, Coordinate current, Set<Coordinate> visited) {
        List<Coordinate> directNeighbors = grid.matchNeighbors(current, SolutionDay18::isTraversable, true);
        directNeighbors = directNeighbors.stream().filter(c -> !visited.contains(c)).toList();
        ArrayList<Pair<Coordinate, Integer>> weightedNeighbors = new ArrayList<Pair<Coordinate, Integer>>();
        for (Coordinate neighbor : directNeighbors) {
            int cost = 2;
            weightedNeighbors.add(new Pair<Coordinate, Integer>(neighbor, cost));
        }
        return weightedNeighbors;
    }

    public Map<Coordinate, Coordinate> findBestMazeSolution(Grid<Character> grid, Coordinate startPoint) {
        HashSet<Coordinate> visited = new HashSet<Coordinate>();
        PriorityQueue<Pair<Coordinate, Integer>> queue = new PriorityQueue<Pair<Coordinate, Integer>>(new NeighborComparator());
        HashMap<Coordinate, Integer> distance = new HashMap<Coordinate, Integer>();
        List<Coordinate> mazeCoords = grid.matchCoordinates(SolutionDay18::isTraversable);
        for (Coordinate coordinate : mazeCoords) {
            if (coordinate.equals(startPoint)) {
                distance.put(startPoint, 0);
                continue;
            }
            distance.put(coordinate, Integer.MAX_VALUE);
        }
        HashMap<Coordinate, Coordinate> previous = new HashMap<Coordinate, Coordinate>();
        for (Coordinate c : mazeCoords) {
            previous.put(c, null);
        }
        queue.add(new Pair<Coordinate, Integer>(startPoint, 0));
        while (!queue.isEmpty()) {
            Pair current = (Pair)queue.poll();
            Coordinate coordinate = (Coordinate)current.one();
            int queuedDistance = (Integer)current.two();
            if (queuedDistance > (Integer)distance.get(coordinate)) continue;
            List<Pair<Coordinate, Integer>> neighbors = SolutionDay18.getNeighbors(grid, coordinate, visited);
            for (Pair<Coordinate, Integer> neighbor : neighbors) {
                int newDistance;
                if (neighbor.one().equals(startPoint) || (newDistance = (Integer)distance.get(coordinate) + neighbor.two()) >= (Integer)distance.get(neighbor.one())) continue;
                distance.put(neighbor.one(), newDistance);
                previous.put(neighbor.one(), coordinate);
                queue.add(new Pair<Coordinate, Integer>(neighbor.one(), newDistance));
            }
            visited.add(coordinate);
        }
        return previous;
    }

    public Grid<Character> mazeForPointInTime(Grid<Character> field, List<Coordinate> input, int numNanoSecs) {
        Grid<Character> gridCopy = field.duplicate();
        for (int i = 0; i < numNanoSecs; ++i) {
            gridCopy.set(input.get(i), Character.valueOf('#'));
        }
        return gridCopy;
    }

    @Override
    public Object partOne(PuzzleInput input) {
        ArrayList<String> l = new ArrayList<String>();
        int rowCount = input.isTest() ? 6 : 70;
        int colCount = input.isTest() ? 6 : 70;
        int step = input.isTest() ? 12 : 1024;
        for (int i = 0; i < rowCount + 1; ++i) {
            l.add(".".repeat(colCount + 1));
        }
        Grid<Character> field = Grid.fromStringList(l);
        List<Coordinate> in = input.getLines().stream().map(s -> s.split(",")).map(s -> new Coordinate(Integer.parseInt(s[1]), Integer.parseInt(s[0]))).toList();
        Coordinate startPoint = new Coordinate(0, 0);
        Grid<Character> g = this.mazeForPointInTime(field, in, step);
        Map<Coordinate, Coordinate> prev = this.findBestMazeSolution(g, startPoint);
        ArrayList<Coordinate> pathTaken = new ArrayList<Coordinate>();
        Coordinate currentPosition = new Coordinate(rowCount, colCount);
        while (!currentPosition.equals(startPoint)) {
            Coordinate current = prev.get(currentPosition);
            pathTaken.add(currentPosition);
            currentPosition = current;
        }
        int total = 0;
        for (Coordinate coordinate : pathTaken) {
            ++total;
        }
        return total;
    }

    @Override
    public Object partTwo(PuzzleInput input) {
        ArrayList<String> l = new ArrayList<String>();
        int rowCount = input.isTest() ? 6 : 70;
        int colCount = input.isTest() ? 6 : 70;
        int step = input.isTest() ? 12 : 1024;
        for (int i = 0; i < rowCount + 1; ++i) {
            l.add(".".repeat(colCount + 1));
        }
        Grid<Character> field = Grid.fromStringList(l);
        List<Coordinate> in = input.getLines().stream().map(s -> s.split(",")).map(s -> new Coordinate(Integer.parseInt(s[1]), Integer.parseInt(s[0]))).toList();
        Coordinate startPoint = new Coordinate(0, 0);
        for (int i = step; i < in.size(); ++i) {
            Grid<Character> g = this.mazeForPointInTime(field, in, i);
            Map<Coordinate, Coordinate> prev = this.findBestMazeSolution(g, startPoint);
            Coordinate currentPosition = new Coordinate(rowCount, colCount);
            while (!currentPosition.equals(startPoint)) {
                Coordinate current = prev.get(currentPosition);
                if (current == null) {
                    return String.format("%d,%d", in.get(i - 1).col(), in.get(i - 1).row());
                }
                currentPosition = current;
            }
        }
        return null;
    }

    public static class NeighborComparator
    implements Comparator<Pair<Coordinate, Integer>> {
        @Override
        public int compare(Pair<Coordinate, Integer> o1, Pair<Coordinate, Integer> o2) {
            if (o1.two() < o2.two()) {
                return -1;
            }
            if (o1.two() > o2.two()) {
                return 1;
            }
            return 0;
        }
    }
}

