/*
 * Decompiled with CFR 0.152.
 */
package com.expedient.adventofcodejade.solutions.year2024;

import com.expedient.adventofcodejade.BaseSolution;
import com.expedient.adventofcodejade.common.Pair;
import com.expedient.adventofcodejade.common.PuzzleInput;
import java.util.Arrays;
import java.util.List;

public class SolutionDay17
extends BaseSolution {
    static final long TEST_REGISTER_START = 247839002800000L;

    public SolutionDay17(PuzzleInput input, PuzzleInput sampleInputOne, PuzzleInput sampleInputTwo) {
        super(input, sampleInputOne, sampleInputTwo);
    }

    @Override
    public String partOne(PuzzleInput input) {
        List<String> lines = input.getLines();
        long regA = Long.parseLong(lines.get(0));
        List<Long> program = Arrays.stream(lines.get(1).split(",")).map(Long::parseLong).toList();
        Computer c = new Computer(regA, 0L, 0L, program);
        while (!c.isHalted()) {
            c.step();
        }
        String output = c.readOutput();
        return output.substring(0, output.length() - 1);
    }

    @Override
    public Object partTwo(PuzzleInput input) {
        long start;
        List<String> lines = input.getLines();
        List<Long> program = Arrays.stream(lines.get(1).split(",")).map(Long::parseLong).toList();
        StringBuilder sb = new StringBuilder();
        program.forEach(i -> {
            sb.append(i.toString());
            sb.append(",");
        });
        String test = sb.toString();
        for (long i2 = start = program.size() < 10 ? 0L : 247839002800000L; i2 < Long.MAX_VALUE; ++i2) {
            Computer c = new Computer(i2, 0L, 0L, program);
            while (!c.isHalted()) {
                c.step();
            }
            String output = c.readOutput();
            if (!output.equals(test)) continue;
            return i2;
        }
        return null;
    }

    public static class Computer {
        private final List<Long> program;
        private final StringBuilder output;
        private long registerA;
        private long registerB;
        private long registerC;
        private long instructionPointer;
        private boolean halted = false;

        public Computer(long registerA, long registerB, long registerC, List<Long> program) {
            this.registerA = registerA;
            this.registerB = registerB;
            this.registerC = registerC;
            this.program = program;
            this.output = new StringBuilder();
            this.instructionPointer = 0L;
        }

        public void step() {
            Pair<OpCode, Long> ins = this.readInstruction();
            this.performOperation(ins);
        }

        public boolean isHalted() {
            return this.halted;
        }

        public Pair<OpCode, Long> readInstruction() {
            OpCode op = OpCode.fromLong(this.program.get((int)this.instructionPointer));
            Long operand = this.program.get((int)this.instructionPointer + 1);
            return new Pair<OpCode, Long>(op, operand);
        }

        public long getInstructionPointer() {
            return this.instructionPointer;
        }

        public long readCombo(long operand) {
            return switch ((int)operand) {
                case 0, 1, 2, 3 -> operand;
                case 4 -> this.registerA;
                case 5 -> this.registerB;
                case 6 -> this.registerC;
                default -> throw new RuntimeException("Invalid Combo Operand");
            };
        }

        public void advanceInstruction() {
            this.instructionPointer += 2L;
            if (this.instructionPointer >= (long)this.program.size()) {
                this.halted = true;
            }
        }

        public long truncate(long num) {
            return num;
        }

        public String readOutput() {
            return this.output.toString();
        }

        public void performOperation(Pair<OpCode, Long> operation) {
            switch (operation.one().ordinal()) {
                case 0: {
                    long numerator = this.registerA;
                    long denominator = (long)Math.pow(2.0, this.readCombo(operation.two()));
                    this.registerA = this.truncate(numerator / denominator);
                    this.advanceInstruction();
                    break;
                }
                case 1: {
                    this.registerB ^= operation.two().longValue();
                    this.advanceInstruction();
                    break;
                }
                case 2: {
                    this.registerB = this.truncate(this.readCombo(operation.two()) % 8L);
                    this.advanceInstruction();
                    break;
                }
                case 3: {
                    if (this.registerA == 0L) {
                        this.advanceInstruction();
                        return;
                    }
                    this.instructionPointer = operation.two();
                    break;
                }
                case 4: {
                    this.registerB ^= this.registerC;
                    this.advanceInstruction();
                    break;
                }
                case 5: {
                    this.output.append(this.readCombo(operation.two()) % 8L).append(",");
                    this.advanceInstruction();
                    break;
                }
                case 6: {
                    long numerator = this.registerA;
                    long denominator = (long)Math.pow(2.0, this.readCombo(operation.two()));
                    this.registerB = this.truncate(numerator / denominator);
                    this.advanceInstruction();
                    break;
                }
                case 7: {
                    long numerator = this.registerA;
                    long denominator = (long)Math.pow(2.0, this.readCombo(operation.two()));
                    this.registerC = this.truncate(numerator / denominator);
                    this.advanceInstruction();
                }
            }
        }
    }

    public static enum OpCode {
        ADV,
        BXL,
        BST,
        JNZ,
        BXC,
        OUT,
        BDV,
        CDV;


        public static OpCode fromLong(long input) {
            return switch ((int)input) {
                case 0 -> ADV;
                case 1 -> BXL;
                case 2 -> BST;
                case 3 -> JNZ;
                case 4 -> BXC;
                case 5 -> OUT;
                case 6 -> BDV;
                case 7 -> CDV;
                default -> throw new RuntimeException("Invalid OpCode");
            };
        }
    }
}

