/*
 * Decompiled with CFR 0.152.
 */
package com.expedient.adventofcodejade.solutions.year2024;

import com.expedient.adventofcodejade.BaseSolution;
import com.expedient.adventofcodejade.common.Coordinate;
import com.expedient.adventofcodejade.common.Direction;
import com.expedient.adventofcodejade.common.Grid;
import com.expedient.adventofcodejade.common.PuzzleInput;
import com.expedient.adventofcodejade.solutions.year2024.solutionday15helpers.Actor;
import com.expedient.adventofcodejade.solutions.year2024.solutionday15helpers.Block;
import com.expedient.adventofcodejade.solutions.year2024.solutionday15helpers.DoubleBox;
import com.expedient.adventofcodejade.solutions.year2024.solutionday15helpers.MovingActor;
import com.expedient.adventofcodejade.solutions.year2024.solutionday15helpers.Robot;
import com.expedient.adventofcodejade.solutions.year2024.solutionday15helpers.Wall;
import java.util.ArrayList;
import java.util.List;

public class SolutionDay15
extends BaseSolution {
    public SolutionDay15(PuzzleInput input, PuzzleInput sampleInputOne, PuzzleInput sampleInputTwo) {
        super(input, sampleInputOne, sampleInputTwo);
    }

    @Override
    public Object partOne(PuzzleInput input) {
        char[] chars;
        List<String> lines = input.getLines();
        ArrayList<String> gridLines = new ArrayList<String>();
        for (String line : lines) {
            if (line.isBlank()) break;
            gridLines.add(line);
        }
        String robotInstructions = lines.getLast();
        Grid<Character> grid = Grid.fromStringList(gridLines);
        Actor[][] field = new Actor[grid.rowCount()][grid.colCount()];
        Robot robot = null;
        for (int i = 0; i < grid.rowCount(); ++i) {
            block13: for (int j = 0; j < grid.colCount(); ++j) {
                switch (grid.at(i, j).charValue()) {
                    case '@': {
                        robot = new Robot(new Coordinate(i, j), field);
                        field[i][j] = robot;
                        continue block13;
                    }
                    case 'O': {
                        field[i][j] = new Block(new Coordinate(i, j), field);
                        continue block13;
                    }
                    case '#': {
                        field[i][j] = new Wall(new Coordinate(i, j), field);
                    }
                }
            }
        }
        if (robot == null) {
            return "ERROR";
        }
        block14: for (char aChar : chars = robotInstructions.toCharArray()) {
            switch (aChar) {
                case '^': {
                    robot.tryMove(Direction.UP, false);
                    continue block14;
                }
                case '<': {
                    robot.tryMove(Direction.LEFT, false);
                    continue block14;
                }
                case '>': {
                    robot.tryMove(Direction.RIGHT, false);
                    continue block14;
                }
                case 'v': {
                    robot.tryMove(Direction.DOWN, false);
                }
            }
        }
        int total = 0;
        for (int i = 0; i < field.length; ++i) {
            for (int j = 0; j < field[0].length; ++j) {
                if (!(field[i][j] instanceof Block)) continue;
                total += field[i][j].getPosition().col() + field[i][j].getPosition().row() * 100;
            }
        }
        return total;
    }

    @Override
    public Object partTwo(PuzzleInput input) {
        List<String> lines = input.getLines();
        ArrayList<String> gridLines = new ArrayList<String>();
        for (String line : lines) {
            if (line.isBlank()) break;
            gridLines.add(line);
        }
        String robotInstructions = lines.getLast();
        Grid<Character> grid = Grid.fromStringList(gridLines);
        Actor[][] field = new Actor[grid.rowCount()][grid.colCount() * 2];
        MovingActor robot = null;
        for (int i = 0; i < grid.rowCount(); ++i) {
            block13: for (int j = 0; j < grid.colCount() * 2; j += 2) {
                switch (grid.at(i, j / 2).charValue()) {
                    case '@': {
                        robot = new Robot(new Coordinate(i, j), field);
                        field[i][j] = robot;
                        continue block13;
                    }
                    case 'O': {
                        DoubleBox blk = new DoubleBox(new Coordinate(i, j), field);
                        field[i][j] = blk;
                        field[i][j + 1] = blk;
                        continue block13;
                    }
                    case '#': {
                        field[i][j] = new Wall(new Coordinate(i, j), field);
                        field[i][j + 1] = new Wall(new Coordinate(i, j + 1), field);
                    }
                }
            }
        }
        if (robot == null) {
            return "ERROR";
        }
        char[] chars = robotInstructions.toCharArray();
        block14: for (int i = 0; i < chars.length; ++i) {
            char aChar = chars[i];
            switch (aChar) {
                case '^': {
                    robot.tryMove(Direction.UP, false);
                    continue block14;
                }
                case '<': {
                    robot.tryMove(Direction.LEFT, false);
                    continue block14;
                }
                case '>': {
                    robot.tryMove(Direction.RIGHT, false);
                    continue block14;
                }
                case 'v': {
                    robot.tryMove(Direction.DOWN, false);
                }
            }
        }
        int total = 0;
        for (int i = 0; i < field.length; ++i) {
            for (int j = 0; j < field[0].length; ++j) {
                Coordinate p;
                if (!(field[i][j] instanceof DoubleBox) || !(p = field[i][j].getPosition()).equals(new Coordinate(i, j))) continue;
                total += p.col() + p.row() * 100;
            }
        }
        return total;
    }
}

