/*
 * Decompiled with CFR 0.152.
 */
package com.expedient.adventofcodejade.solutions.year2024;

import com.expedient.adventofcodejade.BaseSolution;
import com.expedient.adventofcodejade.common.Coordinate;
import com.expedient.adventofcodejade.common.PuzzleInput;
import com.expedient.adventofcodejade.common.Vector2;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class SolutionDay14
extends BaseSolution {
    public SolutionDay14(PuzzleInput input, PuzzleInput sampleInputOne, PuzzleInput sampleInputTwo) {
        super(input, sampleInputOne, sampleInputTwo);
    }

    public static void printRobots(List<Robot> robots, int rowCount, int colCount, String title) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < colCount; ++j) {
                int row = i;
                int col = j;
                long robotCount = robots.stream().filter(r -> r.position.col() == col && r.position.row() == row).count();
                if (robotCount > 0L) {
                    stringBuilder.append(Long.toString(robotCount));
                    continue;
                }
                stringBuilder.append(" ");
            }
            stringBuilder.append("\n");
        }
        SolutionDay14.clearConsole();
        System.out.print(stringBuilder.toString());
        System.out.printf("================================%s===================================%n", title);
    }

    public static final void clearConsole() {
        try {
            String os = System.getProperty("os.name");
            if (os.contains("Windows")) {
                Runtime.getRuntime().exec("cls");
            } else {
                Runtime.getRuntime().exec("clear");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Object partOne(PuzzleInput input) {
        List<String> lines = input.getLines();
        List<Object> robots = new ArrayList();
        int rowCount = input.isTest() ? 7 : 103;
        int colCount = input.isTest() ? 11 : 101;
        for (String line : lines) {
            int positionCol = Integer.parseInt(line.split("p=")[1].split(",")[0]);
            int positionRow = Integer.parseInt(line.split(",")[1].split(" ")[0]);
            int velocityCol = Integer.parseInt(line.split("v=")[1].split(",")[0]);
            int n = Integer.parseInt(line.split("v=")[1].split(",")[1]);
            robots.add(new Robot(new Coordinate(positionRow, positionCol), new Vector2(n, velocityCol), rowCount, colCount));
        }
        for (int i = 0; i < 100; ++i) {
            robots = robots.stream().map(Robot::performStep).toList();
        }
        int q1 = 0;
        int q2 = 0;
        int q3 = 0;
        int q4 = 0;
        for (Robot robot : robots) {
            Optional<Integer> quad = robot.getQuadrant();
            if (!quad.isPresent()) continue;
            if (quad.get() == 1) {
                ++q1;
            }
            if (quad.get() == 2) {
                ++q2;
            }
            if (quad.get() == 3) {
                ++q3;
            }
            if (quad.get() != 4) continue;
            ++q4;
        }
        return q1 * q2 * q3 * q4;
    }

    @Override
    public Object partTwo(PuzzleInput input) {
        if (input.isTest()) {
            return "SKIPPED: Solution not available for test inputs";
        }
        List<String> lines = input.getLines();
        List<Object> robots = new ArrayList();
        int rowCount = input.isTest() ? 7 : 103;
        int colCount = input.isTest() ? 11 : 101;
        for (String line : lines) {
            int positionCol = Integer.parseInt(line.split("p=")[1].split(",")[0]);
            int n = Integer.parseInt(line.split(",")[1].split(" ")[0]);
            int velocityCol = Integer.parseInt(line.split("v=")[1].split(",")[0]);
            int velocityRow = Integer.parseInt(line.split("v=")[1].split(",")[1]);
            robots.add(new Robot(new Coordinate(n, positionCol), new Vector2(velocityRow, velocityCol), rowCount, colCount));
        }
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            boolean[][] robotLocations = new boolean[rowCount][colCount];
            robots = robots.stream().map(Robot::performStep).toList();
            for (Robot robot : robots) {
                robotLocations[robot.position.row()][robot.position.col()] = true;
            }
            for (int row = 0; row < robotLocations.length; ++row) {
                boolean bl = false;
                for (int col = 0; col < robotLocations[row].length; ++col) {
                    int n;
                    n = robotLocations[row][col] ? ++n : 0;
                    if (n != 10) continue;
                    return i + 1;
                }
            }
        }
        return null;
    }

    public record Robot(Coordinate position, Vector2 velocity, int rowCount, int colCount) {
        public Robot performStep() {
            Robot rat = new Robot(this.velocity.applyWithWraparound(this.position, this.rowCount, this.colCount), this.velocity, this.rowCount, this.colCount);
            return rat;
        }

        public Optional<Integer> getQuadrant() {
            int deadRow = (this.rowCount - 1) / 2;
            int deadCol = (this.colCount - 1) / 2;
            if (this.position.row() < deadRow && this.position.col() < deadCol) {
                return Optional.of(1);
            }
            if (this.position.row() < deadRow && this.position.col() > deadCol) {
                return Optional.of(2);
            }
            if (this.position.row() > deadRow && this.position.col() < deadCol) {
                return Optional.of(3);
            }
            if (this.position.row() > deadRow && this.position.col() > deadCol) {
                return Optional.of(4);
            }
            return Optional.empty();
        }
    }
}

