/*
 * Decompiled with CFR 0.152.
 */
package com.expedient.adventofcodejade.solutions.year2024;

import com.expedient.adventofcodejade.BaseSolution;
import com.expedient.adventofcodejade.common.Pair;
import com.expedient.adventofcodejade.common.PuzzleInput;
import com.expedient.adventofcodejade.util.NumTools;
import java.util.ArrayList;
import java.util.List;

public class SolutionDay13
extends BaseSolution {
    public SolutionDay13(PuzzleInput input, PuzzleInput sampleInputOne, PuzzleInput sampleInputTwo) {
        super(input, sampleInputOne, sampleInputTwo);
    }

    public List<Machine> getMachines(PuzzleInput input, boolean partTwo) {
        Pair<Long, Long> currentA = null;
        Pair<Long, Long> currentB = null;
        ArrayList<Machine> machines = new ArrayList<Machine>();
        for (String line : input.getLines()) {
            long two;
            long one;
            if (line.contains("Button A")) {
                one = Long.parseLong(line.split("Button A: X\\+")[1].split(", ")[0]);
                two = Long.parseLong(line.split("Y+")[1]);
                currentA = new Pair<Long, Long>(one, two);
            }
            if (line.contains("Button B")) {
                one = Long.parseLong(line.split("Button B: X\\+")[1].split(", ")[0]);
                two = Long.parseLong(line.split("Y+")[1]);
                currentB = new Pair<Long, Long>(one, two);
            }
            if (!line.contains("Prize") || currentA == null || currentB == null) continue;
            one = Long.parseLong(line.split("Prize: X=")[1].split(", ")[0]);
            two = Long.parseLong(line.split("Y=")[1]);
            Pair<Long, Long> prizeLocation = partTwo ? new Pair<Long, Long>(one + 10000000000000L, two + 10000000000000L) : new Pair<Long, Long>(one, two);
            machines.add(new Machine(currentA, currentB, prizeLocation));
        }
        return machines;
    }

    public long solveMachines(List<Machine> machines) {
        long total = 0L;
        for (Machine machine : machines) {
            long[] coefficientsA = new long[]{machine.buttonA.one(), machine.buttonA.two()};
            long[] coefficientsB = new long[]{machine.buttonB.one(), machine.buttonB.two()};
            long[] constantsC = new long[]{machine.prize.one(), machine.prize.two()};
            long[] answers = NumTools.solveSystemOfEquations(coefficientsA, coefficientsB, constantsC);
            long locX = answers[0] * machine.buttonA.one() + answers[1] * machine.buttonB.one();
            long locY = answers[0] * machine.buttonA.two() + answers[1] * machine.buttonB.two();
            if (locX != machine.prize.one() || locY != machine.prize.two()) continue;
            total += answers[0] * 3L + answers[1];
        }
        return total;
    }

    @Override
    public Long partOne(PuzzleInput input) {
        List<Machine> machines = this.getMachines(input, false);
        return this.solveMachines(machines);
    }

    @Override
    public Long partTwo(PuzzleInput input) {
        List<Machine> machines = this.getMachines(input, true);
        return this.solveMachines(machines);
    }

    public record Machine(Pair<Long, Long> buttonA, Pair<Long, Long> buttonB, Pair<Long, Long> prize) {
    }
}

