/*
 * Decompiled with CFR 0.152.
 */
package com.expedient.adventofcodejade.solutions.year2024;

import com.expedient.adventofcodejade.BaseSolution;
import com.expedient.adventofcodejade.common.PuzzleInput;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class SolutionDay11
extends BaseSolution {
    public SolutionDay11(PuzzleInput input, PuzzleInput sampleInputOne, PuzzleInput sampleInputTwo) {
        super(input, sampleInputOne, sampleInputTwo);
    }

    public static void applyToHashMap(HashMap<Long, Long> input) {
        HashMap<Long, Long> dupe = new HashMap<Long, Long>(input);
        input.clear();
        for (Long key : dupe.keySet()) {
            Long amt = dupe.get(key);
            if (key == 0L) {
                input.put(1L, input.getOrDefault(1L, 0L) + amt);
                continue;
            }
            if (key.toString().length() % 2 == 0) {
                String str = key.toString();
                int mid = str.length() / 2;
                String[] parts = new String[]{str.substring(0, mid), str.substring(mid)};
                long parsedOne = Long.parseLong(parts[0]);
                long parsedTwo = Long.parseLong(parts[1]);
                input.put(parsedOne, input.getOrDefault(parsedOne, 0L) + amt);
                input.put(parsedTwo, input.getOrDefault(parsedTwo, 0L) + amt);
                continue;
            }
            input.put(key * 2024L, input.getOrDefault(key * 2024L, 0L) + amt);
        }
    }

    public Long runBlinkIterations(PuzzleInput input, int iterationCount) {
        List<Long> nums = Arrays.stream(input.getLines().get(0).split(" ")).map(Long::parseLong).toList();
        HashMap<Long, Long> numberMap = new HashMap<Long, Long>();
        for (Long num : nums) {
            if (numberMap.containsKey(num)) {
                numberMap.put(num, numberMap.get(num) + 1L);
                continue;
            }
            numberMap.put(num, 1L);
        }
        for (int i = 0; i < iterationCount; ++i) {
            SolutionDay11.applyToHashMap(numberMap);
        }
        Long total = 0L;
        for (Long key : numberMap.keySet()) {
            total = total + numberMap.get(key);
        }
        return total;
    }

    @Override
    public Long partOne(PuzzleInput input) {
        return this.runBlinkIterations(input, 25);
    }

    @Override
    public Long partTwo(PuzzleInput input) {
        return this.runBlinkIterations(input, 75);
    }
}

