/*
 * Decompiled with CFR 0.152.
 */
package com.expedient.adventofcodejade.solutions.year2015;

import com.expedient.adventofcodejade.BaseSolution;
import com.expedient.adventofcodejade.common.Coordinate;
import com.expedient.adventofcodejade.common.PuzzleInput;
import com.expedient.adventofcodejade.util.StringTools;
import java.util.HashMap;

public class SolutionDay3
extends BaseSolution {
    public SolutionDay3(PuzzleInput input, PuzzleInput sampleInputOne, PuzzleInput sampleInputTwo) {
        super(input, sampleInputOne, sampleInputTwo);
    }

    @Override
    public String partOne(PuzzleInput input) {
        HashMap<Coordinate, Integer> coords = new HashMap<Coordinate, Integer>();
        int x = 0;
        int y = 0;
        coords.put(new Coordinate(x, y), 1);
        Character[] characterArray = StringTools.ToCharacterArray(input.getString());
        int n = characterArray.length;
        for (int j = 0; j < n; ++j) {
            char c = characterArray[j].charValue();
            switch (c) {
                case 'v': {
                    --y;
                    break;
                }
                case '^': {
                    ++y;
                    break;
                }
                case '>': {
                    ++x;
                    break;
                }
                case '<': {
                    --x;
                }
            }
            Coordinate current = new Coordinate(x, y);
            if (coords.containsKey(current)) {
                coords.put(current, (Integer)coords.get(current) + 1);
                continue;
            }
            coords.put(current, 1);
        }
        return Long.toString(coords.values().stream().filter(i -> i >= 1).count());
    }

    @Override
    public String partTwo(PuzzleInput input) {
        HashMap<Coordinate, Integer> coords = new HashMap<Coordinate, Integer>();
        int x1 = 0;
        int y1 = 0;
        int x2 = 0;
        int y2 = 0;
        coords.put(new Coordinate(x1, y1), 2);
        boolean turn = false;
        Character[] characterArray = StringTools.ToCharacterArray(input.getString());
        int n = characterArray.length;
        for (int j = 0; j < n; ++j) {
            Coordinate current;
            char c = characterArray[j].charValue();
            if (turn) {
                switch (c) {
                    case 'v': {
                        --y1;
                        break;
                    }
                    case '^': {
                        ++y1;
                        break;
                    }
                    case '>': {
                        ++x1;
                        break;
                    }
                    case '<': {
                        --x1;
                    }
                }
                current = new Coordinate(x1, y1);
            } else {
                switch (c) {
                    case 'v': {
                        --y2;
                        break;
                    }
                    case '^': {
                        ++y2;
                        break;
                    }
                    case '>': {
                        ++x2;
                        break;
                    }
                    case '<': {
                        --x2;
                    }
                }
                current = new Coordinate(x2, y2);
            }
            if (coords.containsKey(current)) {
                coords.put(current, (Integer)coords.get(current) + 1);
            } else {
                coords.put(current, 1);
            }
            turn = !turn;
        }
        return Long.toString(coords.values().stream().filter(i -> i >= 1).count());
    }
}

