/*
 * Decompiled with CFR 0.152.
 */
package com.expedient.adventofcodejade.common;

import com.expedient.adventofcodejade.common.Coordinate;

public record Vector2(int rowDiff, int colDiff) {
    public Vector2(Coordinate one, Coordinate two) {
        this(one.row() - two.row(), one.col() - two.col());
    }

    public Vector2 reverse() {
        return new Vector2(this.rowDiff() * -1, this.colDiff() * -1);
    }

    public Vector2 multiply(int multiple) {
        return new Vector2(this.rowDiff() * multiple, this.colDiff() * multiple);
    }

    public Coordinate apply(Coordinate src) {
        return new Coordinate(src.row() + this.rowDiff(), src.col() + this.colDiff());
    }

    public Coordinate applyWithWraparound(Coordinate src, int rowCount, int colCount) {
        int newRow = src.row() + this.rowDiff();
        int newCol = src.col() + this.colDiff();
        newRow = (newRow %= rowCount) < 0 ? newRow + rowCount : newRow;
        newCol = newCol < 0 ? newCol + colCount : (newCol %= colCount);
        return new Coordinate(newRow, newCol);
    }
}

