/*
 * Decompiled with CFR 0.152.
 */
package com.expedient.adventofcodejade.common;

import com.expedient.adventofcodejade.BaseSolution;
import com.expedient.adventofcodejade.common.PuzzleInput;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;

public class SolutionLoader {
    private final String inputsDirectory;
    private final String solutionsPackage;
    private final ClassLoader classLoader;

    public SolutionLoader(String inputsDirectory, String solutionsPackage) {
        this.inputsDirectory = inputsDirectory;
        this.solutionsPackage = solutionsPackage;
        this.classLoader = this.getClass().getClassLoader();
    }

    public SolutionLoader() {
        this("inputs", "com.expedient.adventofcodejade.solutions");
    }

    public BaseSolution loadForDay(int year, int day, boolean test) throws ClassNotFoundException, RuntimeException, IOException {
        PuzzleInput input;
        String inputPath = "%s/%d/%d".formatted(this.inputsDirectory, year, day);
        String className = "%s.year%d.SolutionDay%d".formatted(this.solutionsPackage, year, day);
        PuzzleInput sampleInputOne = PuzzleInput.sampleForDay(year, day, true);
        PuzzleInput sampleInputTwo = PuzzleInput.sampleForDay(year, day, false);
        try {
            input = PuzzleInput.fromPath(inputPath);
        }
        catch (IOException e) {
            if (!test) {
                System.out.printf("No input for day %d found in ./inputs, using sample input instead.%n", day);
            }
            input = null;
        }
        try {
            Class<?> cls = this.classLoader.loadClass(className);
            Constructor<?> constructor = cls.getConstructor(PuzzleInput.class, PuzzleInput.class, PuzzleInput.class);
            return (BaseSolution)constructor.newInstance(input, sampleInputOne, sampleInputTwo);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public BaseSolution[] loadSolutions(int year, boolean test) throws RuntimeException {
        ArrayList<BaseSolution> solutions = new ArrayList<BaseSolution>(25);
        for (int i = 1; i < 26; ++i) {
            try {
                BaseSolution solution = this.loadForDay(year, i, test);
                solutions.add(solution);
                continue;
            }
            catch (IOException | ClassNotFoundException e) {
                break;
            }
        }
        return (BaseSolution[])solutions.toArray(BaseSolution[]::new);
    }
}

