/*
 * Decompiled with CFR 0.152.
 */
package com.expedient.adventofcodejade.common;

import com.expedient.adventofcodejade.common.Grid;
import com.expedient.adventofcodejade.common.Pair;
import com.expedient.adventofcodejade.util.StringTools;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class PuzzleInput {
    private final List<String> fileLines;
    private final boolean isTest;

    private PuzzleInput(String inputString, boolean isTest) {
        this.fileLines = Arrays.stream(inputString.split("\n")).map(String::trim).toList();
        this.isTest = isTest;
    }

    private PuzzleInput(String inputString) {
        this(inputString, false);
    }

    public static PuzzleInput fromPath(String inputPath) throws IOException {
        File puzzleInputFile = new File(inputPath);
        return new PuzzleInput(Files.readString(puzzleInputFile.toPath()));
    }

    public static PuzzleInput fromResource(String resourcePath) throws IOException {
        try (InputStream in = PuzzleInput.class.getClassLoader().getResourceAsStream(resourcePath);){
            if (in == null) {
                throw new IOException("Resource not found");
            }
            PuzzleInput puzzleInput = new PuzzleInput(new String(in.readAllBytes(), StandardCharsets.UTF_8), true);
            return puzzleInput;
        }
    }

    public static PuzzleInput sampleForDay(int year, int day, boolean partOne) throws IOException {
        try {
            int suffix = partOne ? 1 : 2;
            return PuzzleInput.fromResource("samples/%d/%d-%d".formatted(year, day, suffix));
        }
        catch (IOException e) {
            return PuzzleInput.fromResource("samples/%d/%d".formatted(year, day));
        }
    }

    public boolean isTest() {
        return this.isTest;
    }

    public List<String> getLines() {
        return this.fileLines;
    }

    public String getString() {
        return String.join((CharSequence)"\n", this.fileLines);
    }

    public <T> List<List<T>> getTwoLists(Function<String, T> conversion, String delimiterRegex) {
        ArrayList<T> listOne = new ArrayList<T>();
        ArrayList<T> listTwo = new ArrayList<T>();
        for (String line : this.fileLines) {
            String[] split = line.split(delimiterRegex);
            listOne.add(conversion.apply(split[0]));
            listTwo.add(conversion.apply(split[1]));
        }
        return Arrays.asList(listOne, listTwo);
    }

    public <T> List<List<T>> allMatchesPerLine(Predicate<Character> test, Function<Character, T> conversion, Function<String, String> transform) {
        ArrayList<List<T>> parsed = new ArrayList<List<T>>();
        Iterator<String> iterator = this.fileLines.iterator();
        while (iterator.hasNext()) {
            String line;
            String l = line = iterator.next();
            if (transform != null) {
                l = transform.apply(l);
            }
            Character[] chars = StringTools.ToCharacterArray(l);
            parsed.add(Arrays.stream(chars).filter(test).map(conversion).toList());
        }
        return parsed;
    }

    public Grid<Character> getGrid() throws IllegalArgumentException {
        return Grid.fromStringList(this.fileLines);
    }

    public Pair<List<Pair<Integer, Integer>>, List<List<Integer>>> day5Input() {
        String[] split;
        int i;
        ArrayList<Pair<Integer, Integer>> pairList = new ArrayList<Pair<Integer, Integer>>();
        ArrayList intLists = new ArrayList();
        int breakPoint = 0;
        for (i = 0; i < this.fileLines.size(); ++i) {
            if (this.fileLines.get(i).isBlank()) {
                breakPoint = i + 1;
                break;
            }
            split = this.fileLines.get(i).split("\\|");
            pairList.add(new Pair<Integer, Integer>(Integer.parseInt(split[0]), Integer.parseInt(split[1])));
        }
        for (i = breakPoint; i < this.fileLines.size(); ++i) {
            split = this.fileLines.get(i).split(",");
            intLists.add(Arrays.stream(split).map(Integer::parseInt).collect(Collectors.toList()));
        }
        return new Pair<List<Pair<Integer, Integer>>, List<List<Integer>>>(pairList, intLists);
    }
}

