/*
 * Decompiled with CFR 0.152.
 */
package com.expedient.adventofcodejade.common;

import com.expedient.adventofcodejade.common.Coordinate;
import com.expedient.adventofcodejade.util.StringTools;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;

public class Grid<T> {
    private T[][] array;

    private Grid(T[][] array) {
        this.array = array;
    }

    public static Grid<Character> fromStringList(List<String> lines) {
        List<String> linesCleaned = lines.stream().filter(i -> !i.isEmpty()).toList();
        if (linesCleaned.isEmpty()) {
            throw new IllegalArgumentException("Invalid input: The input cannot be empty");
        }
        int rows = linesCleaned.size();
        int cols = linesCleaned.get(0).length();
        if (linesCleaned.stream().anyMatch(i -> i.length() != cols)) {
            throw new IllegalArgumentException("Invalid input: The input has rows with inconsistent lengths.");
        }
        Character[][] array = new Character[rows][cols];
        for (int i2 = 0; i2 < rows; ++i2) {
            array[i2] = StringTools.ToCharacterArray(linesCleaned.get(i2));
        }
        return new Grid<Character>(array);
    }

    public static int findTrailStepUnique(Grid<Character> grid, Coordinate center, int currentStep) {
        if (grid.at(center).charValue() == '9') {
            return 1;
        }
        List<Coordinate> candidates = grid.safeNeighborCoordinates(center, true);
        candidates = candidates.stream().filter(i -> ((Character)grid.at((Coordinate)i)).charValue() == (char)(48 + currentStep + 1)).toList();
        int total = 0;
        for (Coordinate candidate : candidates) {
            total += Grid.findTrailStepUnique(grid, candidate, currentStep + 1);
        }
        return total;
    }

    public static Set<Coordinate> findTrailStepScore(Grid<Character> grid, Coordinate center, int currentStep) {
        if (grid.at(center).charValue() == '9') {
            HashSet<Coordinate> endpoints = new HashSet<Coordinate>();
            endpoints.add(center);
            return endpoints;
        }
        List<Coordinate> candidates = grid.safeNeighborCoordinates(center, true);
        candidates = candidates.stream().filter(i -> ((Character)grid.at((Coordinate)i)).charValue() == (char)(48 + currentStep + 1)).toList();
        HashSet<Coordinate> endpoints = new HashSet<Coordinate>();
        for (Coordinate candidate : candidates) {
            endpoints.addAll(Grid.findTrailStepScore(grid, candidate, currentStep + 1));
        }
        return endpoints;
    }

    public int rowCount() {
        return this.array.length;
    }

    public int colCount() {
        return this.array[0].length;
    }

    public boolean isSafe(Coordinate location) {
        return location.row() >= 0 && location.row() < this.rowCount() && location.col() >= 0 && location.col() < this.colCount();
    }

    public T at(int row, int col) {
        return this.array[row][col];
    }

    public T at(Coordinate c) {
        return this.array[c.row()][c.col()];
    }

    public void set(int row, int col, T val) {
        this.array[row][col] = val;
    }

    public void set(Coordinate c, T val) {
        this.array[c.row()][c.col()] = val;
    }

    public T[][] getArray() {
        return this.array;
    }

    public void setArray(T[][] newArray) {
        this.array = newArray;
    }

    public T[][] cloneArray() {
        Object[][] copy = (Object[][])this.array.clone();
        for (int row = 0; row < this.rowCount(); ++row) {
            copy[row] = (Object[])this.array[row].clone();
        }
        return copy;
    }

    public int checkCorner(Coordinate center, Predicate<T> test) {
        boolean bottomCenter;
        int corners = 0;
        boolean topLeft = !this.isSafe(center.topLeft()) || !test.test(this.at(center.topLeft()));
        boolean topRight = !this.isSafe(center.topRight()) || !test.test(this.at(center.topRight()));
        boolean bottomLeft = !this.isSafe(center.bottomLeft()) || !test.test(this.at(center.bottomLeft()));
        boolean bottomRight = !this.isSafe(center.bottomRight()) || !test.test(this.at(center.bottomRight()));
        boolean centerLeft = !this.isSafe(center.centerLeft()) || !test.test(this.at(center.centerLeft()));
        boolean centerRight = !this.isSafe(center.centerRight()) || !test.test(this.at(center.centerRight()));
        boolean topCenter = !this.isSafe(center.topCenter()) || !test.test(this.at(center.topCenter()));
        boolean bl = bottomCenter = !this.isSafe(center.bottomCenter()) || !test.test(this.at(center.bottomCenter()));
        if (centerLeft && topCenter) {
            ++corners;
        }
        if (centerLeft && bottomCenter) {
            ++corners;
        }
        if (centerRight && topCenter) {
            ++corners;
        }
        if (centerRight && bottomCenter) {
            ++corners;
        }
        if (bottomRight && !centerRight && !bottomCenter) {
            ++corners;
        }
        if (bottomLeft && !centerLeft && !bottomCenter) {
            ++corners;
        }
        if (topLeft && !centerLeft && !topCenter) {
            ++corners;
        }
        if (topRight && !centerRight && !topCenter) {
            ++corners;
        }
        return corners;
    }

    public List<Coordinate> safeNeighborCoordinates(Coordinate center, boolean orthogonalOnly) {
        int maxCol;
        ArrayList<Coordinate> safeCoords = new ArrayList<Coordinate>();
        int row = center.row();
        int col = center.col();
        int minRow = row == 0 ? 0 : row - 1;
        int maxRow = row == this.rowCount() - 1 ? row : row + 1;
        int minCol = col == 0 ? 0 : col - 1;
        int n = maxCol = col == this.colCount() - 1 ? col : col + 1;
        if (orthogonalOnly) {
            if (col > 0) {
                safeCoords.add(new Coordinate(row, minCol));
            }
            if (col != this.colCount() - 1) {
                safeCoords.add(new Coordinate(row, maxCol));
            }
            if (row > 0) {
                safeCoords.add(new Coordinate(minRow, col));
            }
            if (row != this.rowCount() - 1) {
                safeCoords.add(new Coordinate(maxRow, col));
            }
            return safeCoords;
        }
        for (int currentRow = minRow; currentRow <= maxRow; ++currentRow) {
            for (int currentCol = minCol; currentCol <= maxCol; ++currentCol) {
                if (currentRow == row && currentCol == col) continue;
                safeCoords.add(new Coordinate(currentRow, currentCol));
            }
        }
        return safeCoords;
    }

    public List<Coordinate> matchCoordinates(Predicate<T> test) {
        ArrayList<Coordinate> matches = new ArrayList<Coordinate>();
        for (int row = 0; row < this.rowCount(); ++row) {
            for (int col = 0; col < this.colCount(); ++col) {
                if (!test.test(this.at(row, col))) continue;
                matches.add(new Coordinate(row, col));
            }
        }
        return matches;
    }

    public List<Coordinate> matchCoordinatesByCoordinate(Predicate<Coordinate> test) {
        ArrayList<Coordinate> matches = new ArrayList<Coordinate>();
        for (int row = 0; row < this.rowCount(); ++row) {
            for (int col = 0; col < this.colCount(); ++col) {
                if (!test.test(new Coordinate(row, col))) continue;
                matches.add(new Coordinate(row, col));
            }
        }
        return matches;
    }

    public List<Coordinate> coordinatesWithinTaxicabDistance(Coordinate one, int maxDistance, Predicate<T> test) {
        int minRow = Math.max(0, one.row() - maxDistance);
        int maxRow = Math.min(this.rowCount() - 1, one.row() + maxDistance);
        int minCol = Math.max(0, one.col() - maxDistance);
        int maxCol = Math.min(this.colCount() - 1, one.col() + maxDistance);
        ArrayList<Coordinate> coords = new ArrayList<Coordinate>();
        for (int row = minRow; row < maxRow; ++row) {
            for (int col = minCol; col < maxCol; ++col) {
                if (Math.abs(one.row() - row) + Math.abs(one.col() - col) > maxDistance) continue;
                Coordinate coord = new Coordinate(row, col);
                if (test != null && test.test(this.at(coord))) {
                    coords.add(coord);
                    continue;
                }
                if (test != null) continue;
                coords.add(coord);
            }
        }
        return coords;
    }

    public List<Coordinate> coordinatesWithinTaxicabDistance(Coordinate one, int maxDistance) {
        return this.coordinatesWithinTaxicabDistance(one, maxDistance, null);
    }

    public List<Coordinate> adjacentCoordinates(Coordinate center, boolean vertical) {
        List<Coordinate> safeCoords = this.safeNeighborCoordinates(center, true);
        if (vertical) {
            return safeCoords.stream().filter(i -> i.col() == center.col()).toList();
        }
        return safeCoords.stream().filter(i -> i.row() == center.row()).toList();
    }

    public boolean checkNeighbors(Coordinate center, Predicate<T> test, boolean orthogonalOnly) {
        List<Coordinate> safe = this.safeNeighborCoordinates(center, orthogonalOnly);
        return safe.stream().anyMatch(i -> test.test(this.at((Coordinate)i)));
    }

    public boolean checkNeighbors(Coordinate center, Predicate<T> test) {
        return this.checkNeighbors(center, test, false);
    }

    public List<Coordinate> matchNeighbors(Coordinate center, Predicate<T> test, boolean orthogonalOnly) {
        List<Coordinate> safe = this.safeNeighborCoordinates(center, orthogonalOnly);
        return safe.stream().filter(i -> test.test(this.at((Coordinate)i))).toList();
    }

    public List<Coordinate> matchNeighbors(Coordinate center, Predicate<T> test) {
        return this.matchNeighbors(center, test, false);
    }

    public Grid<T> floodFill(Coordinate center, Predicate<T> test, Function<T, T> transformation) {
        if (!test.test(this.at(center))) {
            return this;
        }
        this.set(center, transformation.apply(this.at(center)));
        List<Coordinate> coords = this.safeNeighborCoordinates(center, true);
        coords.forEach(c -> this.floodFill((Coordinate)c, test, transformation));
        return this;
    }

    public Integer findContiguousRegionPerimeter(Coordinate center, Predicate<T> test, Set<Coordinate> prev) {
        int total = 0;
        if (prev == null) {
            prev = new HashSet<Coordinate>();
        }
        if (!test.test(this.at(center))) {
            return total;
        }
        List<Coordinate> coords = this.safeNeighborCoordinates(center, true);
        total += 4 - coords.size();
        prev.add(center);
        for (Coordinate coordinate : coords) {
            if (!test.test(this.at(coordinate))) {
                ++total;
                continue;
            }
            if (prev.contains(coordinate)) continue;
            total += this.findContiguousRegionPerimeter(coordinate, test, prev).intValue();
        }
        return total;
    }

    public Integer findContiguousRegionSides(Coordinate center, Predicate<T> test, Set<Coordinate> prev) {
        int total = 0;
        if (!test.test(this.at(center))) {
            return total;
        }
        if (prev == null) {
            prev = new HashSet<Coordinate>();
        }
        List<Coordinate> coords = this.safeNeighborCoordinates(center, true);
        total += this.checkCorner(center, test);
        prev.add(center);
        for (Coordinate coordinate : coords) {
            if (!test.test(this.at(coordinate)) || prev.contains(coordinate)) continue;
            total += this.findContiguousRegionSides(coordinate, test, prev).intValue();
        }
        return total;
    }

    public Integer findContiguousRegionArea(Coordinate center, Predicate<T> test, Set<Coordinate> prev) {
        if (!test.test(this.at(center))) {
            return 0;
        }
        int total = 1;
        if (prev == null) {
            prev = new HashSet<Coordinate>();
        }
        List<Coordinate> coords = this.safeNeighborCoordinates(center, true);
        prev.add(center);
        for (Coordinate coordinate : coords) {
            if (prev.contains(coordinate)) continue;
            total += this.findContiguousRegionArea(coordinate, test, prev).intValue();
        }
        return total;
    }

    public void print(Function<Coordinate, Character> characterFunction) {
        for (int rows = 0; rows < this.rowCount(); ++rows) {
            for (int cols = 0; cols < this.colCount(); ++cols) {
                System.out.print(characterFunction.apply(new Coordinate(rows, cols)));
            }
            System.out.println();
        }
    }

    public void print() {
        for (int rows = 0; rows < this.rowCount(); ++rows) {
            for (int cols = 0; cols < this.colCount(); ++cols) {
                System.out.print(this.at(rows, cols));
            }
            System.out.println();
        }
    }

    public Grid<T> duplicate() {
        T[][] clone = this.cloneArray();
        return new Grid<T>(clone);
    }
}

