/*
 * Decompiled with CFR 0.152.
 */
package com.expedient.adventofcodejade.common;

import com.expedient.adventofcodejade.common.Coordinate;
import java.util.List;
import java.util.stream.Stream;

public enum Direction {
    UP{

        @Override
        public Direction turn() {
            return RIGHT;
        }

        @Override
        public Coordinate next(Coordinate location) {
            return new Coordinate(location.row() - 1, location.col());
        }
    }
    ,
    RIGHT{

        @Override
        public Direction turn() {
            return DOWN;
        }

        @Override
        public Coordinate next(Coordinate location) {
            return new Coordinate(location.row(), location.col() + 1);
        }
    }
    ,
    DOWN{

        @Override
        public Direction turn() {
            return LEFT;
        }

        @Override
        public Coordinate next(Coordinate location) {
            return new Coordinate(location.row() + 1, location.col());
        }
    }
    ,
    LEFT{

        @Override
        public Direction turn() {
            return UP;
        }

        @Override
        public Coordinate next(Coordinate location) {
            return new Coordinate(location.row(), location.col() - 1);
        }
    };


    public static List<Direction> all() {
        return Stream.of(UP, DOWN, LEFT, RIGHT).toList();
    }

    public abstract Direction turn();

    public Direction turnCounterClockwise() {
        return this.turn().turn().turn();
    }

    public abstract Coordinate next(Coordinate var1);
}

