/*
 * Decompiled with CFR 0.152.
 */
package com.expedient.adventofcodejade.common;

import com.expedient.adventofcodejade.common.Direction;

public record Coordinate(int row, int col) {
    public Coordinate nextInDirection(Coordinate other) {
        int r = other.row();
        int c = other.col();
        if (other.row() > this.row()) {
            ++r;
        }
        if (other.row() < this.row()) {
            --r;
        }
        if (other.col() > this.col()) {
            ++c;
        }
        if (other.col() < this.col()) {
            --c;
        }
        return new Coordinate(r, c);
    }

    public Coordinate inOppositeDirection(Coordinate other) {
        int r = this.row();
        int c = this.col();
        if (other.row() > this.row()) {
            --r;
        }
        if (other.row() < this.row()) {
            ++r;
        }
        if (other.col() > this.col()) {
            --c;
        }
        if (other.col() < this.col()) {
            ++c;
        }
        return new Coordinate(r, c);
    }

    public boolean isOrthogonal(Coordinate other) {
        return this.row() == other.row() || this.col() == other.col();
    }

    public int taxiCabDistance(Coordinate other) {
        int rowDist = Math.abs(this.row() - other.row());
        int colDist = Math.abs(this.col() - other.col());
        return rowDist + colDist;
    }

    public Direction directionToCoordinate(Coordinate c2) {
        Direction newDirection = Direction.RIGHT;
        if (this.row() < c2.row()) {
            newDirection = Direction.DOWN;
        }
        if (this.row() > c2.row()) {
            newDirection = Direction.UP;
        }
        if (this.col() < c2.col()) {
            newDirection = Direction.RIGHT;
        }
        if (this.col() > c2.col()) {
            newDirection = Direction.LEFT;
        }
        return newDirection;
    }

    public double distance(Coordinate other) {
        int rowDist = this.row() - other.row();
        int colDist = this.col() - other.col();
        return Math.sqrt(Math.pow(rowDist, 2.0) + Math.pow(colDist, 2.0));
    }

    public Coordinate topLeft() {
        return new Coordinate(this.row - 1, this.col - 1);
    }

    public Coordinate topCenter() {
        return new Coordinate(this.row - 1, this.col);
    }

    public Coordinate topRight() {
        return new Coordinate(this.row - 1, this.col + 1);
    }

    public Coordinate centerRight() {
        return new Coordinate(this.row, this.col + 1);
    }

    public Coordinate bottomRight() {
        return new Coordinate(this.row + 1, this.col + 1);
    }

    public Coordinate bottomCenter() {
        return new Coordinate(this.row + 1, this.col);
    }

    public Coordinate bottomLeft() {
        return new Coordinate(this.row + 1, this.col - 1);
    }

    public Coordinate centerLeft() {
        return new Coordinate(this.row, this.col - 1);
    }
}

