/*
 * Decompiled with CFR 0.152.
 */
package com.expedient.adventofcodejade;

import com.expedient.adventofcodejade.common.PuzzleInput;
import java.time.Duration;
import java.time.Instant;

public abstract class BaseSolution {
    private final PuzzleInput input;
    private final PuzzleInput sampleInputOne;
    private final PuzzleInput sampleInputTwo;

    public BaseSolution(PuzzleInput input, PuzzleInput sampleInputOne, PuzzleInput sampleInputTwo) {
        this.input = input;
        this.sampleInputOne = sampleInputOne;
        this.sampleInputTwo = sampleInputTwo;
    }

    public PuzzleInput getInput(boolean test, boolean partOne) {
        if (test || this.input == null) {
            return partOne ? this.sampleInputOne : this.sampleInputTwo;
        }
        return this.input;
    }

    public void run(boolean test, boolean metrics) {
        String pfx = test ? "output (sample)" : "output";
        Instant startOne = Instant.now();
        Object partOneSolution = this.partOne(this.getInput(test, true));
        Instant endOne = Instant.now();
        if (!metrics) {
            System.out.printf("Part one %s: %s%n", pfx, partOneSolution);
        } else {
            Duration time = Duration.between(startOne, endOne);
            System.out.printf("Part one %s: %s (took %s)%n", pfx, partOneSolution, time);
        }
        Instant startTwo = Instant.now();
        Object partTwoSolution = this.partTwo(this.getInput(test, false));
        Instant endTwo = Instant.now();
        if (!metrics) {
            System.out.printf("Part two %s: %s%n", pfx, partTwoSolution);
        } else {
            Duration time = Duration.between(startTwo, endTwo);
            System.out.printf("Part two %s: %s (took %s)%n", pfx, partTwoSolution, time);
        }
    }

    public abstract Object partOne(PuzzleInput var1);

    public abstract Object partTwo(PuzzleInput var1);
}

