/*
 * Decompiled with CFR 0.152.
 */
package com.expedient.adventofcodejade;

import com.expedient.adventofcodejade.BaseSolution;
import com.expedient.adventofcodejade.common.SolutionLoader;
import com.expedient.adventofcodejade.util.PrintTools;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Year;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class AdventOfCode {
    public static void main(String[] args) {
        boolean test = Arrays.asList(args).contains("--test");
        boolean metrics = Arrays.asList(args).contains("--metrics");
        SolutionLoader loader = new SolutionLoader();
        if (!test && !Files.exists(Path.of("inputs", new String[0]), new LinkOption[0])) {
            System.out.println("No ./inputs directory exists, using sample inputs.");
            test = true;
        }
        if (Arrays.asList(args).contains("--help")) {
            PrintTools.printHelp();
            return;
        }
        List<String> selectedDay = Arrays.stream(args).filter(s -> s.startsWith("--day=")).toList();
        List<String> selectedYear = Arrays.stream(args).filter(s -> s.startsWith("--year=")).toList();
        if (!selectedYear.isEmpty() && !selectedDay.isEmpty()) {
            AdventOfCode.runForDay(selectedYear.get(0), selectedDay.get(0), test, loader, metrics);
            return;
        }
        if (!selectedYear.isEmpty()) {
            AdventOfCode.runAllSolutionsForYear(selectedYear.get(0), test, loader, metrics);
            return;
        }
        if (!selectedDay.isEmpty()) {
            AdventOfCode.runForDay(Integer.toString(Year.now().getValue()), selectedDay.get(0), test, loader, metrics);
            return;
        }
        if (Arrays.asList(args).contains("--all")) {
            AdventOfCode.runAllSolutions(test, loader, metrics);
        } else {
            AdventOfCode.runLatestSolution(test, loader, metrics);
        }
    }

    public static void runForDay(String yearArg, String dayArg, boolean test, SolutionLoader loader, boolean metrics) {
        int selectedYear = Integer.parseInt(yearArg.split("=")[1]);
        int selectedDay = Integer.parseInt(dayArg.split("=")[1]);
        try {
            BaseSolution solution = loader.loadForDay(selectedYear, selectedDay, test);
            System.out.printf(PrintTools.dayHeader(selectedYear, selectedDay, false), new Object[0]);
            solution.run(test, metrics);
        }
        catch (ClassNotFoundException e) {
            System.out.printf("The selected day, %d-%d, does not have a valid solution%n", selectedYear, selectedDay);
        }
        catch (IOException e) {
            System.out.printf("The selected day, %d-%d, has no valid input or sample input%n", selectedYear, selectedDay);
        }
    }

    public static void runLatestSolution(boolean test, SolutionLoader loader, boolean metrics) {
        ArrayList<BaseSolution> solutions = new ArrayList<BaseSolution>();
        int lastYear = 0;
        int lastDay = 0;
        int year = 2015;
        while (year <= 2024) {
            List<BaseSolution> yearSolutions = Arrays.stream(loader.loadSolutions(year, test)).toList();
            solutions.addAll(yearSolutions);
            lastDay = yearSolutions.size();
            lastYear = year++;
        }
        System.out.printf(PrintTools.dayHeader(lastYear, lastDay, false), new Object[0]);
        ((BaseSolution)solutions.get(solutions.size() - 1)).run(test, metrics);
    }

    public static void runAllSolutionsForYear(int year, boolean test, SolutionLoader loader, boolean metrics) {
        BaseSolution[] solutions = loader.loadSolutions(year, test);
        for (int i = 0; i < solutions.length; ++i) {
            System.out.printf(PrintTools.dayHeader(year, i, true), new Object[0]);
            solutions[i].run(test, metrics);
        }
    }

    public static void runAllSolutionsForYear(String yearInput, boolean test, SolutionLoader loader, boolean metrics) {
        int year = Integer.parseInt(yearInput.split("=")[1]);
        AdventOfCode.runAllSolutionsForYear(year, test, loader, metrics);
    }

    public static void runAllSolutions(boolean test, SolutionLoader loader, boolean metrics) {
        for (int year = 2015; year <= 2024; ++year) {
            AdventOfCode.runAllSolutionsForYear(year, test, loader, metrics);
        }
    }
}

